#! /bin/sh

echo "running test1.sh for imedian ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  non-square, no map, no mask, double, single pass
# ------------------------------------------------------------------------
test_num=1
descr="non-square, no map, no mask, double, single pass"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4
1 1 1 1
1 1 0 1
1 1 1 1
EOF
imedian -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0
1 1 1 1
1 1 1 1
0 1 1 0
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  non-square, no map, no mask, double, two passes
# ------------------------------------------------------------------------
test_num=2
descr="non-square, no map, no mask, double, two passes"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4
1 1 1 1
1 1 0 1
1 1 1 1
EOF
imedian -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -reps 2
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0
1 1 1 1
1 1 1 1
0 1 1 0
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3:  non-square, no map, no mask, double, 50 passes
# ------------------------------------------------------------------------
test_num=3
descr="non-square, no map, no mask, double, 50 passes"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4
1 1 1 1
1 1 0 1
1 1 1 1
EOF
imedian -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -reps 50
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0
1 1 1 1
1 1 1 1
0 1 1 0
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

exit $status

