 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ipostscr.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ipostscr_get_args
| 
|       Purpose: Gets command line args for ipostscr
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ipostscr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ipostscr_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ipostscr is out of sync with arguments specified in ipostscr's *.pane file; please rerun ghostwriter on ipostscr.";


	/*
	 * allocate the ipostscr structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "width",
			  &(clui_info->width_double),
			  &(clui_info->width_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "height",
			  &(clui_info->height_double),
			  &(clui_info->height_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "xoffset",
			  &(clui_info->xoffset_double),
			  &(clui_info->xoffset_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "yoffset",
			  &(clui_info->yoffset_double),
			  &(clui_info->yoffset_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "showpage",
			  &(clui_info->showpage_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "f",
			  &(clui_info->f_file),
			  &(clui_info->f_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "portrait",
			  &(clui_info->portrait_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "landscape",
			  &(clui_info->landscape_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ps",
			  &(clui_info->ps_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "eps",
			  &(clui_info->eps_flag))))
	{
	    kerror(NULL, "ipostscr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



