 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ipostscr
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ipostscr.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Convert Image to Postscript
|
|       Purpose: main program for ipostscr
|
|         Input:
|		char *clui_info->i_file; {Object to be output in postscript form}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->f_file; {output postscript file}
|		int   clui_info->f_flag; {TRUE if -f specified}
|
|		double clui_info->width_double; {Desired width in inches of the printed image}
|		int    clui_info->width_flag; {TRUE if -width specified}
|
|		double clui_info->height_double; {Desired height of printed image in inches}
|		int    clui_info->height_flag; {TRUE if -height specified}
|
|		double clui_info->xoffset_double; {Width offset in inches from bottom left corner of printed page}
|		int    clui_info->xoffset_flag; {TRUE if -xoffset specified}
|
|		double clui_info->yoffset_double; {Height offset in inches from bottom left corner of printed page }
|		int    clui_info->yoffset_flag; {TRUE if -yoffset specified}
|
|		int clui_info->showpage_flag; {TRUE if -showpage specified}
|
|		Optional M.E. group:
|		    int clui_info->portrait_flag; {TRUE if -portrait specified}
|
|		    int clui_info->landscape_flag; {TRUE if -landscape specified}
|
|		Optional M.E. group:
|		    int clui_info->ps_flag; {TRUE if -ps specified}
|
|		    int clui_info->eps_flag; {TRUE if -eps specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young, Scott Wilson, Jeremy Worley
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kfile *f;
	kobject obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(ipostscr_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "ipostscr",
		ipostscr_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ipostscr_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((f = kfopen(clui_info->f_file, "w+")) == NULL)
	{
	   kerror("image", "ipostscr", "Unable to open output file '%s'.",
		  clui_info->f_file);
	   kexit(KEXIT_FAILURE);
	}
	if ((obj = kpds_open_input_object(clui_info->i_file)) == NULL)
	{
	   kerror("image", "ipostscr", "Unable to open input file '%s'.",
		  clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (lipostscr(f, obj, clui_info->width_double, 
		      clui_info->height_double, clui_info->xoffset_double,
		      clui_info->yoffset_double, 
		      clui_info->width_flag,clui_info->height_flag,
		      clui_info->xoffset_flag,clui_info->yoffset_flag,
		      clui_info->landscape_flag,clui_info->eps_flag,
		      clui_info->showpage_flag) 
	    == FALSE)
	{
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ipostscr_usage_additions
| 
|       Purpose: Prints usage additions in ipostscr_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ipostscr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ipostscr_usage_additions(void)
{
	kfprintf(kstderr, "\tConvert Image to Postscript\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ipostscr_free_args
| 
|       Purpose: Frees CLUI struct allocated in ipostscr_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ipostscr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ipostscr_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->f_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
