 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "igradient.h"
/*-----------------------------------------------------------
| 
|  Routine Name: igradient_get_args
| 
|       Purpose: Gets command line args for igradient
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igradient
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igradient_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for igradient is out of sync with arguments specified in igradient's *.pane file; please rerun ghostwriter on igradient.";


	/*
	 * allocate the igradient structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "abs",
			  &(clui_info->abs_logic),
			  &(clui_info->abs_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "roberts",
			  &(clui_info->roberts_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "sobel",
			  &(clui_info->sobel_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "prewitt",
			  &(clui_info->prewitt_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "isotropic",
			  &(clui_info->isotropic_flag))))
	{
	    kerror(NULL, "igradient_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



