 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "igamut.h"
/*-----------------------------------------------------------
| 
|  Routine Name: igamut_get_args
| 
|       Purpose: Gets command line args for igamut
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igamut
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igamut_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for igamut is out of sync with arguments specified in igamut's *.pane file; please rerun ghostwriter on igamut.";


	/*
	 * allocate the igamut structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "igamut_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "n",
			  &(clui_info->n_int),
			  &(clui_info->n_flag))))
	{
	    kerror(NULL, "igamut_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "p",
			  &(clui_info->p_int),
			  &(clui_info->p_flag))))
	{
	    kerror(NULL, "igamut_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "r",
			  &(clui_info->r_float),
			  &(clui_info->r_flag))))
	{
	    kerror(NULL, "igamut_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "igamut_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



