 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ifilt_design.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ifilt_design_get_args
| 
|       Purpose: Gets command line args for ifilt_design
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ifilt_design
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ifilt_design_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ifilt_design is out of sync with arguments specified in ifilt_design's *.pane file; please rerun ghostwriter on ifilt_design.";


	/*
	 * allocate the ifilt_design structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_value(pane, "pos", KVF_LIST_LABEL,
			  &(clui_info->pos_label),
			  &(clui_info->pos_flag)) &&
	      kclui_get_value(pane, "pos", KVF_LIST_VAL,
			  &(clui_info->pos_cycle),
			  &(clui_info->pos_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_cycle),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "order",
			  &(clui_info->order_int),
			  &(clui_info->order_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "lcutoff",
			  &(clui_info->lcutoff_double),
			  &(clui_info->lcutoff_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ucutoff",
			  &(clui_info->ucutoff_double),
			  &(clui_info->ucutoff_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "lp",
			  &(clui_info->lp_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hp",
			  &(clui_info->hp_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "bp",
			  &(clui_info->bp_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "bs",
			  &(clui_info->bs_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ideal",
			  &(clui_info->ideal_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "but",
			  &(clui_info->but_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "exp",
			  &(clui_info->exp_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ch1",
			  &(clui_info->ch1_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ch2",
			  &(clui_info->ch2_flag))))
	{
	    kerror(NULL, "ifilt_design_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



