 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ifilt_design
   >>>> 
   >>>>    Written By: Steven Jorgensen
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ifilt_design_h_
#define _ifilt_design_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <kimage_proc/kimage_proc.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/ifilt_design/uis/ifilt_design.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Output frequency filter image (required outfile)
 */
char	*o_file;	/* Output frequency filter image FILENAME */
int	 o_flag;	/* Output frequency filter image FLAG */

/*----- required ME group ----*/
/*
 *  Low Pass (optional flag)
 */
int	 lp_flag;  	/* Low Pass FLAG */

/*
 *  High Pass (optional flag)
 */
int	 hp_flag;  	/* High Pass FLAG */

/*
 *  Band Pass (optional flag)
 */
int	 bp_flag;  	/* Band Pass FLAG */

/*
 *  Band Stop (optional flag)
 */
int	 bs_flag;  	/* Band Stop FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  Ideal filter (optional flag)
 */
int	 ideal_flag;  	/* Ideal filter FLAG */

/*
 *  butterworth (optional flag)
 */
int	 but_flag;  	/* butterworth FLAG */

/*
 *  exponential (optional flag)
 */
int	 exp_flag;  	/* exponential FLAG */

/*
 *  chebyshev1 (optional flag)
 */
int	 ch1_flag;  	/* chebyshev1 FLAG */

/*
 *  chebyshev2 (optional flag)
 */
int	 ch2_flag;  	/* chebyshev2 FLAG */

/*-- required ME group end ---*/

/*
 *  Low frequencies located at image center or corners (Optional cycle)
 */
int	 pos_cycle;	/* Low frequencies located at image center or corners CYCLE INDEX */
char	 *pos_label;	/* Low frequencies located at image center or corners CYCLE LABEL */
int	 pos_flag;	/* Low frequencies located at image center or corners FLAG */

/*
 *  Type of frequency image to output (Optional cycle)
 */
int	 type_cycle;	/* Type of frequency image to output CYCLE INDEX */
char	 *type_label;	/* Type of frequency image to output CYCLE LABEL */
int	 type_flag;	/* Type of frequency image to output FLAG */

/*
 *  Filter order (optional integer)
 */
int	 order_int; 	/* Filter order INT */
int	 order_flag;	/* Filter order FLAG */

/*
 *  Normalized lower cutoff frequency (optional double)
 */
double	 lcutoff_double;	/* Normalized lower cutoff frequency DOUBLE */
int	 lcutoff_flag;   	/* Normalized lower cutoff frequency FLAG */

/*
 *  Normalized upper cutoff frequency (optional double)
 */
double	 ucutoff_double;	/* Normalized upper cutoff frequency DOUBLE */
int	 ucutoff_flag;   	/* Normalized upper cutoff frequency FLAG */

/*
 *  Image height size (optional integer)
 */
int	 hsize_int; 	/* Image height size INT */
int	 hsize_flag;	/* Image height size FLAG */

/*
 *  Image width size (optional integer)
 */
int	 wsize_int; 	/* Image width size INT */
int	 wsize_flag;	/* Image width size FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ifilt_design_get_args PROTO((kform *));
void ifilt_design_usage_additions PROTO((void));
void ifilt_design_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
