
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <design.h>

#include <geometry.h>
#include "sort_trans.h"
#include "zbuffer.h"

static float *zbuffer=NULL;
static int xsize=0,ysize=0;

#define ZINIT 1e10

int
init_zbuffer(int x,int y)
{
    register float *f;
    register int i;
    
    deinit_zbuffer();
    
    f = zbuffer = (float *)kmalloc(sizeof(float) * x * y);
    if (f == NULL)
    {
	kfprintf(kstderr,"ERROR: can't malloc space for zbuffer.\n");
	return(WHACKED);
    }

    xsize = x;
    ysize = y;
    for (i=0;i<x*y;i++)
	*f++ = ZINIT;
    return(CHILL);
}

int
deinit_zbuffer()
{
    if (zbuffer != NULL)
	kfree(zbuffer);
    zbuffer=NULL;
    return(CHILL);
}

int
reset_zbuffer()
{
    register float *z;
    register int i;

    z = zbuffer;
    for (i=0;i<xsize*ysize;i++)
	*z++ = ZINIT;
    return(CHILL);
}

int
zbuf_read(int x,int y,float *val)
{
    /* range check on x/y ? */
    
    *val = *(zbuffer+x+y*xsize);
    return(CHILL);
}

int
zbuf_write(int x,int y,float val)
{
    *(zbuffer+x+y*xsize) = val;
    return(CHILL);
}


#if 0
static char zbuf_fname[] = {"zbuf.ras"};
int
dump_zbuffer()
{
    float zmin,zmax,zscale;
    float *z;
    int i,j;
    FILE *f;
    unsigned char *linebuf;
    
    struct rasterfile head;
    head.ras_magic = RAS_MAGIC;
    head.ras_width = xsize;
    head.ras_height = ysize;
    head.ras_depth = 8;
    head.ras_length = xsize*ysize;
    head.ras_type = RT_STANDARD;
    head.ras_maptype = RMT_NONE;
    head.ras_maplength = 0;
    
    f = fopen(zbuf_fname,"w");
    fwrite((char *)&head,sizeof(struct rasterfile),1,f);

    zmin = ZINIT;
    zmax = -ZINIT;
    
    z = zbuffer;
    for (j=0;j<ysize;j++)
    {
	for (i=0;i<xsize;i++,z++)
	{
	    if (*z != ZINIT)
	    {
		if (*z < zmin)
		    zmin = *z;
		if (*z > zmax)
		    zmax = *z;
	    }
	}
    }

    z = zbuffer;
    zscale = (254.)/(zmax - zmin);
    
    linebuf = (unsigned char *)malloc(xsize*sizeof(unsigned char));
    for (j=0;j<ysize;j++)
    {
	for (i=0;i<xsize;i++,z++)
	{
	    if (*z == ZINIT)
		linebuf[i] = 0;
	    else
		linebuf[i] = (unsigned char)((*z - zmin) * zscale);
	}
	fwrite((char *)linebuf,sizeof(unsigned char),xsize,f);
    }

    free((char *)linebuf);
    fclose(f);
}


#endif
