
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#ifndef __rmonster_objs_h_
#define __rmonster_objs_h_

#include "geometry/geometry.h"

#define TRANSPARENT_OBJ 0
#define OPAQUE_OBJ 1

#define MAXOFFSPRING 12

static char ROOT_OBJECT_NAME[] = {"root"};

typedef struct surface_attribs
{
    KGEOM_VERTEX_TYPE amb,diff,spec,spec_exp,spec_metal;
} surface_attribs;

typedef struct surface_colors_rgba
{
    KGEOM_VERTEX_TYPE r,g,b,a;
} surface_colors_rgba;


typedef struct surface_colors_rgb
{
    KGEOM_VERTEX_TYPE r,g,b;
} surface_colors_rgb;

typedef struct rmonster_prim
{
    int type;
    
    int nverts;
    vertex_3d *verts;
    
    int nthings;
    union
    {
	vertex_3d *normals;
	float *radii;
    } prim_specifics;

    int mesh_dims[3]; /* used for holding sizing info for qmesh, omesh */
    int ncolors;
    surface_colors_rgb *rgb_color_list;
    surface_colors_rgba *rgba_color_list;
    int pshader;

    int (*clipfunc)();
} rmonster_prim;

typedef struct rmonsterobj
{
    int nparents,nchildren;
    struct rmonsterobj *parents[MAXOFFSPRING];
    struct rmonsterobj *children[MAXOFFSPRING];
    char name[KGEOM_MAX_NAME_LENGTH];
    unsigned int flags;

    matrix4x4 xfrm;  /* obsolete 8/8/94 wes */
    
    vertex_3d translate_vect;
    vertex_3d rotate_vect;
    vertex_3d scale_vect;
    vertex_3d center;
    vertex_3d bmin,bmax;  /* for bounding box. */
    
    surface_attribs attribs;
    surface_colors_rgba colors;

    int do_display;
    int is_transparent; /* this is different from HAS_ALPHA */
    int has_alpha;

    int nprims;
    rmonster_prim *prims;

    int layout;

    /**
      * since a geom object is comprised of several primitives,
      * the notion of an object level shader applying to heterogeneous
      * primitives is slippery.  for now, we are assuming that
      * all the primitive types are homogeneous (ie, all volumetric,
      * all surface based, or all wireframe) and that all of the
      * primitives will use the object-level shader.
    **/
    int shader;
} rmonsterobj;


void init_rmonster_obj PROTO((rmonsterobj *, char *));
rmonsterobj *create_rmonsterobj PROTO(());
int convert_kobj_to_rmonsterobj PROTO((char *, rmonsterobj *));
int add_child PROTO((rmonsterobj *,rmonsterobj *));
int find_rmonsterobj PROTO((char *, rmonsterobj **));
rmonsterobj *get_current_object PROTO(());
rmonsterobj *get_root_object PROTO(());

int set_object_bbox PROTO((rmonsterobj *, vertex_3d *,vertex_3d *));
int get_object_bbox PROTO((rmonsterobj *, vertex_3d *,vertex_3d *));
int set_current_object PROTO((rmonsterobj *));
int set_object_shader PROTO((rmonsterobj *, int));
int get_object_shader PROTO((rmonsterobj *, int *));
int set_object_display_status PROTO((rmonsterobj *, int));
int get_object_display_status PROTO((rmonsterobj *, int *));
int get_object_rgba PROTO((rmonsterobj *, float *, float *, float *, float *));
int set_object_rgba PROTO((rmonsterobj *, float, float, float, float));

int set_object_amb PROTO((rmonsterobj *, float));
int get_object_amb PROTO((rmonsterobj *, float *));

int set_object_diff PROTO((rmonsterobj *, float));
int get_object_diff PROTO((rmonsterobj *, float *));

int set_object_spec PROTO((rmonsterobj *, float));
int get_object_spec PROTO((rmonsterobj *, float *));

int set_object_spec_exp PROTO((rmonsterobj *, float));
int get_object_spec_exp PROTO((rmonsterobj *, float *));

int set_object_metal PROTO((rmonsterobj *, float));
int get_object_metal PROTO((rmonsterobj *, float *));

void geom_xform_points PROTO((matrix4x4 *,vertex_3d*, vertex_3d *,vertex_3d *,vertex_3d *,matrix4x4 *,vertex_3d *,int));

void  replace_input_object PROTO((int,rmonsterobj *));
int identity_current_object_matrix PROTO(());
#endif
