 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for rmonster
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactive Geometry Visualization
|
|       Purpose: main program for rmonster
|
|         Input:
|		char *clui_info->i1_file; {Input file 1}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Input file 2}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->i3_file; {Input file 3}
|		int   clui_info->i3_flag; {TRUE if -i3 specified}
|
|		char *clui_info->i4_file; {Input file 4}
|		int   clui_info->i4_flag; {TRUE if -i4 specified}
|
|		int   clui_info->view_list; {viewing method for rendered image}
|		char *clui_info->view_label;
|		int   clui_info->view_flag; {TRUE if -view specified}
|
|		int clui_info->wsize_int; {width of rendered image}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {height of rendered image}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->norm_logic; {compute view so all objects appear in the render window.}
|		int clui_info->norm_flag; {TRUE if -norm specified}
|
|		int   clui_info->proj_list; {Projection method to use when rendering}
|		char *clui_info->proj_label;
|		int   clui_info->proj_flag; {TRUE if -proj specified}
|
|		float clui_info->eye_x_float; {x component of eye position.}
|		int   clui_info->eye_x_flag; {TRUE if -eye_x specified}
|
|		float clui_info->up_x_float; {x component of up vector.}
|		int   clui_info->up_x_flag; {TRUE if -up_x specified}
|
|		float clui_info->at_x_float; {x component of initial look-at point.}
|		int   clui_info->at_x_flag; {TRUE if -at_x specified}
|
|		float clui_info->eye_y_float; {y component of eye position.}
|		int   clui_info->eye_y_flag; {TRUE if -eye_y specified}
|
|		float clui_info->up_y_float; {y component of up vector.}
|		int   clui_info->up_y_flag; {TRUE if -up_y specified}
|
|		float clui_info->at_y_float; {y component of initial look-at point.}
|		int   clui_info->at_y_flag; {TRUE if -at_y specified}
|
|		float clui_info->eye_z_float; {z component of eye position.}
|		int   clui_info->eye_z_flag; {TRUE if -eye_z specified}
|
|		float clui_info->up_z_float; {z component of up vector.}
|		int   clui_info->up_z_flag; {TRUE if -up_z specified}
|
|		float clui_info->at_z_float; {z component of initial look-at point.}
|		int   clui_info->at_z_flag; {TRUE if -at_z specified}
|
|		float clui_info->hither_float; {Location of front clip plane. (1 is look-at point, 0 is view point)}
|		int   clui_info->hither_flag; {TRUE if -hither specified}
|
|		float clui_info->yon_float; {Location of back clip plane. (0 is look-at point, 1 is view point)}
|		int   clui_info->yon_flag; {TRUE if -yon specified}
|
|		int clui_info->bc_logic; {turns back clipping on or off.}
|		int clui_info->bc_flag; {TRUE if -bc specified}
|
|		char *clui_info->o_file; {Output rendered image}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 15, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for rmonster    */ 
	char   *form_pathname;   /* location of rmonster.form   */
	char   *form_fullpath;   /* expanded rmonster.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(rmonster_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "GEOMETRY", "rmonster",
		rmonster_usage_additions);

	rmonster_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of rmonster.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("rmonster.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/rmonster/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for rmonster 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_Master, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_Master(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
        /**
          * deal with opening input object(s)
         **/

        init_object_list(clui_info);

        /**
          * initialize the output mechanism.
        **/
        set_do_named_output(clui_info->o_flag);
        if (clui_info->o_flag)
            set_output_transport_name(clui_info->o_file);

        identify_software_renderer();
        identify_native_renderer();
        
        /**
          * init imaging pane
        **/
        set_image_dims(clui_info->wsize_int,clui_info->hsize_int);
        
        /* UI counts from 1, not zero */
/*      set_image_display_choice(clui_info->view_list - 1); */
        set_image_display_choice(clui_info->view_list);
        
        /**
          * do the user-specified options for display choice, w/h, etc.
          * conflict with anything? are they sensible?
        **/

        renderer_init_func();


        /**
          * initialize the lights database
        **/
        init_lights();

        /**
          * initialize the various components of the GUI.
        **/

        /**
          * first, update the "objects" pane.  the init function
          * is different than the "update" function.  the transformations
          * call must precede the object list call. 
        **/
        init_transformations(gui_info->RenderMonster->Transformations);
        init_object_list_GUI(gui_info->RenderMonster->Objects);  
        init_input_pane_GUI(clui_info,gui_info->RenderMonster->Input);

        init_imaging_pane(gui_info->RenderMonster->Imaging);


        /**
          * next, update the "cameras" pane.
        **/
        init_camera(clui_info);
        update_cameras_pane_GUI(gui_info->RenderMonster->Cameras);

        /**
          * initialize the stuff on the LIGHTS pane.
        **/
        init_lights_pane(gui_info->RenderMonster->Lights);

        /* do the output pane */
        init_output_pane_GUI(clui_info,gui_info->RenderMonster->Output);

	/* if we're gonna have an image, do an initial rendering */
	if (clui_info->view_list != sNO_DISPLAY)
	   renderer_invoke_func();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: rmonster_usage_additions
| 
|       Purpose: Prints usage additions in rmonster_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname rmonster
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void rmonster_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractive Geometry Visualization\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: rmonster_free_args
| 
|       Purpose: Frees CLUI struct allocated in rmonster_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname rmonster
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
rmonster_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->i3_file);
	kfree(clui_info->i4_file);
	kfree(clui_info->view_label);
	kfree(clui_info->proj_label);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
