
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
		Berkeley, California

  "this software is 100% hand-crafted by a human being in the USA"

10 jan 95, wes. 
     changed how xsteps, ysteps are computed to fix lingering weirdness.


*********************************************************************/



#include <design.h>
#include <geometry.h>
#include <math.h>
#include "poly.h"


#define BIGNUM 1e10
    
line_draw(Poly *line,
	  PWindow *win,
	  void (*pixelproc)(),
	  surface_colors_rgba *color1,
	  surface_colors_rgba *color2)
{
    int xsteps,ysteps;
    float x,y,m;
    double dz,temp1,temp2;
    Poly_vert p;
    int ix,iy,idx,idy;
    int start,end;

#ifdef DEBUG
    kfprintf(kstderr,"Drawing line from %g,%g to %g,%g\n",line->vert[0].sx,line->vert[0].sy,line->vert[1].sx,line->vert[1].sy);
#endif

#if 0    
    xsteps = (int)(line->vert[1].sx) - (int)(line->vert[0].sx);
    ysteps = (int)(line->vert[1].sy) - (int)(line->vert[0].sy);
#endif
    xsteps = (int)(line->vert[1].sx - line->vert[0].sx);
    ysteps = (int)(line->vert[1].sy - line->vert[0].sy);

/*    if (kabs(xsteps) < kabs(ysteps))  /* increment along y */
    if (IABS(xsteps) < IABS(ysteps))  /* increment along y */
    {
	if (line->vert[0].sy < line->vert[1].sy)
	{
	    start = 0;
	    end = 1;
	}
	else
	{
	    start = 1;
	    end = 0;
	}

#if 0	
	xsteps = (int)(line->vert[end].sx) - (int)(line->vert[start].sx);
	ysteps = (int)(line->vert[end].sy) - (int)(line->vert[start].sy);
#endif
	xsteps = (int)(line->vert[end].sx - line->vert[start].sx);
	ysteps = (int)(line->vert[end].sy - line->vert[start].sy);

	if (xsteps == 0.)
	    m = 0.;
	else
	    m = (line->vert[end].sx - line->vert[start].sx)/(line->vert[end].sy - line->vert[start].sy);

	idy = 1.;

	if (ysteps != 0)
	    dz = (line->vert[end].sz - line->vert[start].sz)/(ysteps);
	else
	    dz = 0.;
	p.sz = line->vert[start].sz;
	
	
	for (iy=line->vert[start].sy,
	     x=line->vert[start].sx; ;iy+=idy,x+=m,ysteps--)
	{
	    ix = x;

	    (*pixelproc)(ix, iy, &p);
	     if ((ysteps == 0) || (iy >= (int)(line->vert[end].sy)))
		 break;

	    p.sz += dz;
	}

    }
    else  /* increment along X */
    {
	if (line->vert[0].sx < line->vert[1].sx)
	{
	    start = 0;
	    end = 1;
	}
	else
	{
	    start = 1;
	    end = 0;
	}

	xsteps = (int)(line->vert[end].sx - line->vert[start].sx);
	ysteps = (int)(line->vert[end].sy - line->vert[start].sy);

	if (xsteps == 0.)
	    m = BIGNUM;
	else
	    m = (line->vert[end].sy - line->vert[start].sy)/(line->vert[end].sx - line->vert[start].sx);

	idx = 1.;
	if (xsteps != 0)
	    dz = (line->vert[end].sz - line->vert[start].sz)/(xsteps);
	else
	    dz = 0.;
	p.sz = line->vert[start].sz;

	for (y=line->vert[start].sy,
	     ix=line->vert[start].sx; ;ix+=idx,y+=m,xsteps--)
	{
	    iy = y;
	    
	    (*pixelproc)(ix, iy, &p);
	     if ((xsteps==0) || (ix >= (int)(line->vert[end].sx)))
		 break;

	    p.sz += dz;
	}
    }	
    return(CHILL);
}


