 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'rmonster'
   >>>> 
   >>>>  Private: 
   >>>> 	run_Master
   >>>> 	run_RenderMonster
   >>>> 	run_Objects
   >>>> 	run_Cameras
   >>>> 	run_Lights
   >>>> 	run_Imaging
   >>>> 	run_Transformations
   >>>> 	run_Input
   >>>> 	run_Output
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_Master
| 
|       Purpose: Main GUI Driver for rmonster
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_Master(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_Master(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_Master(master_info);
	    return;
	}

	/*
	 * action came from the 'RenderMonster' subform
	 */
	if (master_info->RenderMonster_selected)
	    run_RenderMonster(master_info->RenderMonster);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_RenderMonster
| 
|       Purpose: GUI Driver for subform 'RenderMonster'
| 
|         Input: form      - pointer to the form tree
|                RenderMonster_info - pointer to Master_RenderMonster struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_RenderMonster(
     Master_RenderMonster *RenderMonster_info)
{

	/*
	 * user clicked on pane action button selection 'refresh'
	 */
	if (RenderMonster_info->refresh)
	{
	    RenderMonster_refresh(RenderMonster_info);
	    RenderMonster_info->refresh = FALSE;
	}
	/*
	 * action came from the 'Objects' pane
	 */
	else if (RenderMonster_info->Objects_selected)
	    run_Objects(RenderMonster_info->Objects);

	/*
	 * action came from the 'Cameras' pane
	 */
	else if (RenderMonster_info->Cameras_selected)
	    run_Cameras(RenderMonster_info->Cameras);

	/*
	 * action came from the 'Lights' pane
	 */
	else if (RenderMonster_info->Lights_selected)
	    run_Lights(RenderMonster_info->Lights);

	/*
	 * action came from the 'Imaging' pane
	 */
	else if (RenderMonster_info->Imaging_selected)
	    run_Imaging(RenderMonster_info->Imaging);

	/*
	 * action came from the 'Transformations' pane
	 */
	else if (RenderMonster_info->Transformations_selected)
	    run_Transformations(RenderMonster_info->Transformations);

	/*
	 * action came from the 'Input' pane
	 */
	else if (RenderMonster_info->Input_selected)
	    run_Input(RenderMonster_info->Input);

	/*
	 * action came from the 'Output' pane
	 */
	else if (RenderMonster_info->Output_selected)
	    run_Output(RenderMonster_info->Output);


}   /* end run_RenderMonster */



/*-----------------------------------------------------------
| 
|  Routine Name: run_Objects
| 
|       Purpose: GUI Driver for pane 'Objects'
| 
|         Input: form - pointer to the form tree
|                Objects_info - pointer to RenderMonster_Objects struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Objects(
     RenderMonster_Objects *Objects_info)

{

	/*
	 * user selected 'live' list selection 'current_object'
	 */
	if ((Objects_info->current_object_selected)  && (Objects_info->current_object_optsel))
	{
	    Objects_current_object(Objects_info);
	    Objects_info->current_object_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'object_shader'
	 */
	else if ((Objects_info->object_shader_selected)  && (Objects_info->object_shader_optsel))
	{
	    Objects_object_shader(Objects_info);
	    Objects_info->object_shader_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'post_obj'
	 */
	else if ((Objects_info->post_obj_selected)  && (Objects_info->post_obj_optsel))
	{
	    Objects_post_obj(Objects_info);
	    Objects_info->post_obj_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_red'
	 */
	else if ((Objects_info->obj_red_selected)  && (Objects_info->obj_red_optsel))
	{
	    Objects_obj_red(Objects_info);
	    Objects_info->obj_red_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_green'
	 */
	else if ((Objects_info->obj_green_selected)  && (Objects_info->obj_green_optsel))
	{
	    Objects_obj_green(Objects_info);
	    Objects_info->obj_green_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_blue'
	 */
	else if ((Objects_info->obj_blue_selected)  && (Objects_info->obj_blue_optsel))
	{
	    Objects_obj_blue(Objects_info);
	    Objects_info->obj_blue_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_alpha'
	 */
	else if ((Objects_info->obj_alpha_selected)  && (Objects_info->obj_alpha_optsel))
	{
	    Objects_obj_alpha(Objects_info);
	    Objects_info->obj_alpha_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_ambient'
	 */
	else if ((Objects_info->obj_ambient_selected)  && (Objects_info->obj_ambient_optsel))
	{
	    Objects_obj_ambient(Objects_info);
	    Objects_info->obj_ambient_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_diffuse'
	 */
	else if ((Objects_info->obj_diffuse_selected)  && (Objects_info->obj_diffuse_optsel))
	{
	    Objects_obj_diffuse(Objects_info);
	    Objects_info->obj_diffuse_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_spec'
	 */
	else if ((Objects_info->obj_spec_selected)  && (Objects_info->obj_spec_optsel))
	{
	    Objects_obj_spec(Objects_info);
	    Objects_info->obj_spec_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_spec_exp'
	 */
	else if ((Objects_info->obj_spec_exp_selected)  && (Objects_info->obj_spec_exp_optsel))
	{
	    Objects_obj_spec_exp(Objects_info);
	    Objects_info->obj_spec_exp_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'obj_spec_metal'
	 */
	else if ((Objects_info->obj_spec_metal_selected)  && (Objects_info->obj_spec_metal_optsel))
	{
	    Objects_obj_spec_metal(Objects_info);
	    Objects_info->obj_spec_metal_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'object_info'
	 */
	else if (Objects_info->object_info)
	{
	    Objects_object_info(Objects_info);
	    Objects_info->object_info = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'action1'
	 */
	else if (Objects_info->action1)
	{
	    Objects_action1(Objects_info);
	    Objects_info->action1 = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Cameras
| 
|       Purpose: GUI Driver for pane 'Cameras'
| 
|         Input: form - pointer to the form tree
|                Cameras_info - pointer to RenderMonster_Cameras struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Cameras(
     RenderMonster_Cameras *Cameras_info)

{

	/*
	 * user selected 'live' cycle selection 'projection_cycle'
	 */
	if ((Cameras_info->projection_cycle_selected)  && (Cameras_info->projection_cycle_optsel))
	{
	    Cameras_projection_cycle(Cameras_info);
	    Cameras_info->projection_cycle_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'eye_x'
	 */
	else if ((Cameras_info->eye_x_selected)  && (Cameras_info->eye_x_optsel))
	{
	    Cameras_eye_x(Cameras_info);
	    Cameras_info->eye_x_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'up_x'
	 */
	else if ((Cameras_info->up_x_selected)  && (Cameras_info->up_x_optsel))
	{
	    Cameras_up_x(Cameras_info);
	    Cameras_info->up_x_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'at_x'
	 */
	else if ((Cameras_info->at_x_selected)  && (Cameras_info->at_x_optsel))
	{
	    Cameras_at_x(Cameras_info);
	    Cameras_info->at_x_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'eye_y'
	 */
	else if ((Cameras_info->eye_y_selected)  && (Cameras_info->eye_y_optsel))
	{
	    Cameras_eye_y(Cameras_info);
	    Cameras_info->eye_y_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'up_y'
	 */
	else if ((Cameras_info->up_y_selected)  && (Cameras_info->up_y_optsel))
	{
	    Cameras_up_y(Cameras_info);
	    Cameras_info->up_y_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'at_y'
	 */
	else if ((Cameras_info->at_y_selected)  && (Cameras_info->at_y_optsel))
	{
	    Cameras_at_y(Cameras_info);
	    Cameras_info->at_y_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'eye_z'
	 */
	else if ((Cameras_info->eye_z_selected)  && (Cameras_info->eye_z_optsel))
	{
	    Cameras_eye_z(Cameras_info);
	    Cameras_info->eye_z_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'up_z'
	 */
	else if ((Cameras_info->up_z_selected)  && (Cameras_info->up_z_optsel))
	{
	    Cameras_up_z(Cameras_info);
	    Cameras_info->up_z_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'at_z'
	 */
	else if ((Cameras_info->at_z_selected)  && (Cameras_info->at_z_optsel))
	{
	    Cameras_at_z(Cameras_info);
	    Cameras_info->at_z_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'hither_clip_form_loc'
	 */
	else if ((Cameras_info->hither_clip_form_loc_selected)  && (Cameras_info->hither_clip_form_loc_optsel))
	{
	    Cameras_hither_clip_form_loc(Cameras_info);
	    Cameras_info->hither_clip_form_loc_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'yon_clip_form_loc'
	 */
	else if ((Cameras_info->yon_clip_form_loc_selected)  && (Cameras_info->yon_clip_form_loc_optsel))
	{
	    Cameras_yon_clip_form_loc(Cameras_info);
	    Cameras_info->yon_clip_form_loc_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'back_clip_form_on_off'
	 */
	else if ((Cameras_info->back_clip_form_on_off_selected)  && (Cameras_info->back_clip_form_on_off_optsel))
	{
	    Cameras_back_clip_form_on_off(Cameras_info);
	    Cameras_info->back_clip_form_on_off_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'fov_input'
	 */
	else if ((Cameras_info->fov_input_selected)  && (Cameras_info->fov_input_optsel))
	{
	    Cameras_fov_input(Cameras_info);
	    Cameras_info->fov_input_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'aspect'
	 */
	else if ((Cameras_info->aspect_selected)  && (Cameras_info->aspect_optsel))
	{
	    Cameras_aspect(Cameras_info);
	    Cameras_info->aspect_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'normalize_cam'
	 */
	else if (Cameras_info->normalize_cam)
	{
	    Cameras_normalize_cam(Cameras_info);
	    Cameras_info->normalize_cam = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'reset_camera'
	 */
	else if (Cameras_info->reset_camera)
	{
	    Cameras_reset_camera(Cameras_info);
	    Cameras_info->reset_camera = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Lights
| 
|       Purpose: GUI Driver for pane 'Lights'
| 
|         Input: form - pointer to the form tree
|                Lights_info - pointer to RenderMonster_Lights struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Lights(
     RenderMonster_Lights *Lights_info)

{

	/*
	 * user selected 'live' list selection 'light_list'
	 */
	if ((Lights_info->light_list_selected)  && (Lights_info->light_list_optsel))
	{
	    Lights_light_list(Lights_info);
	    Lights_info->light_list_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'light_onoff'
	 */
	else if ((Lights_info->light_onoff_selected)  && (Lights_info->light_onoff_optsel))
	{
	    Lights_light_onoff(Lights_info);
	    Lights_info->light_onoff_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'light_type_list'
	 */
	else if ((Lights_info->light_type_list_selected)  && (Lights_info->light_type_list_optsel))
	{
	    Lights_light_type_list(Lights_info);
	    Lights_info->light_type_list_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'light_position_string'
	 */
	else if ((Lights_info->light_position_string_selected)  && (Lights_info->light_position_string_optsel))
	{
	    Lights_light_position_string(Lights_info);
	    Lights_info->light_position_string_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'light_direction_string'
	 */
	else if ((Lights_info->light_direction_string_selected)  && (Lights_info->light_direction_string_optsel))
	{
	    Lights_light_direction_string(Lights_info);
	    Lights_info->light_direction_string_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'current_light_color_string'
	 */
	else if ((Lights_info->current_light_color_string_selected)  && (Lights_info->current_light_color_string_optsel))
	{
	    Lights_current_light_color_string(Lights_info);
	    Lights_info->current_light_color_string_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'ambient_light_color_string'
	 */
	else if ((Lights_info->ambient_light_color_string_selected)  && (Lights_info->ambient_light_color_string_optsel))
	{
	    Lights_ambient_light_color_string(Lights_info);
	    Lights_info->ambient_light_color_string_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Imaging
| 
|       Purpose: GUI Driver for pane 'Imaging'
| 
|         Input: form - pointer to the form tree
|                Imaging_info - pointer to RenderMonster_Imaging struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Imaging(
     RenderMonster_Imaging *Imaging_info)

{

	/*
	 * user selected 'live' integer selection 'image_width'
	 */
	if ((Imaging_info->image_width_selected)  && (Imaging_info->image_width_optsel))
	{
	    Imaging_image_width(Imaging_info);
	    Imaging_info->image_width_selected = FALSE;
	}
	/*
	 * user selected 'live' integer selection 'image_height'
	 */
	else if ((Imaging_info->image_height_selected)  && (Imaging_info->image_height_optsel))
	{
	    Imaging_image_height(Imaging_info);
	    Imaging_info->image_height_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'image_display_choice'
	 */
	else if ((Imaging_info->image_display_choice_selected)  && (Imaging_info->image_display_choice_optsel))
	{
	    Imaging_image_display_choice(Imaging_info);
	    Imaging_info->image_display_choice_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'red_background'
	 */
	else if ((Imaging_info->red_background_selected)  && (Imaging_info->red_background_optsel))
	{
	    Imaging_red_background(Imaging_info);
	    Imaging_info->red_background_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'green_background'
	 */
	else if ((Imaging_info->green_background_selected)  && (Imaging_info->green_background_optsel))
	{
	    Imaging_green_background(Imaging_info);
	    Imaging_info->green_background_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'blue_background'
	 */
	else if ((Imaging_info->blue_background_selected)  && (Imaging_info->blue_background_optsel))
	{
	    Imaging_blue_background(Imaging_info);
	    Imaging_info->blue_background_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'renderer_choice'
	 */
	else if ((Imaging_info->renderer_choice_selected)  && (Imaging_info->renderer_choice_optsel))
	{
	    Imaging_renderer_choice(Imaging_info);
	    Imaging_info->renderer_choice_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'transparency_choice'
	 */
	else if ((Imaging_info->transparency_choice_selected)  && (Imaging_info->transparency_choice_optsel))
	{
	    Imaging_transparency_choice(Imaging_info);
	    Imaging_info->transparency_choice_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'invoke_renderer'
	 */
	else if ((Imaging_info->invoke_renderer_selected)  && (Imaging_info->invoke_renderer_optsel))
	{
	    Imaging_invoke_renderer(Imaging_info);
	    Imaging_info->invoke_renderer_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'antialias'
	 */
	else if ((Imaging_info->antialias_selected)  && (Imaging_info->antialias_optsel))
	{
	    Imaging_antialias(Imaging_info);
	    Imaging_info->antialias_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Transformations
| 
|       Purpose: GUI Driver for pane 'Transformations'
| 
|         Input: form - pointer to the form tree
|                Transformations_info - pointer to RenderMonster_Transformations struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Transformations(
     RenderMonster_Transformations *Transformations_info)

{

	/*
	 * user selected 'live' float selection 'x_rotate'
	 */
	if ((Transformations_info->x_rotate_selected)  && (Transformations_info->x_rotate_optsel))
	{
	    Transformations_x_rotate(Transformations_info);
	    Transformations_info->x_rotate_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'y_rotate'
	 */
	else if ((Transformations_info->y_rotate_selected)  && (Transformations_info->y_rotate_optsel))
	{
	    Transformations_y_rotate(Transformations_info);
	    Transformations_info->y_rotate_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'z_rotate'
	 */
	else if ((Transformations_info->z_rotate_selected)  && (Transformations_info->z_rotate_optsel))
	{
	    Transformations_z_rotate(Transformations_info);
	    Transformations_info->z_rotate_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'center_point_string'
	 */
	else if ((Transformations_info->center_point_string_selected)  && (Transformations_info->center_point_string_optsel))
	{
	    Transformations_center_point_string(Transformations_info);
	    Transformations_info->center_point_string_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'translate_vector_string'
	 */
	else if ((Transformations_info->translate_vector_string_selected)  && (Transformations_info->translate_vector_string_optsel))
	{
	    Transformations_translate_vector_string(Transformations_info);
	    Transformations_info->translate_vector_string_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'xyz_scale_string'
	 */
	else if ((Transformations_info->xyz_scale_string_selected)  && (Transformations_info->xyz_scale_string_optsel))
	{
	    Transformations_xyz_scale_string(Transformations_info);
	    Transformations_info->xyz_scale_string_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'transformation_mode'
	 */
	else if ((Transformations_info->transformation_mode_selected)  && (Transformations_info->transformation_mode_optsel))
	{
	    Transformations_transformation_mode(Transformations_info);
	    Transformations_info->transformation_mode_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Input
| 
|       Purpose: GUI Driver for pane 'Input'
| 
|         Input: form - pointer to the form tree
|                Input_info - pointer to RenderMonster_Input struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Input(
     RenderMonster_Input *Input_info)

{

	/*
	 * user selected 'live' input file selection 'input_object_1'
	 */
	if ((Input_info->input_object_1_selected)  && (Input_info->input_object_1_optsel))
	{
	    Input_input_object_1(Input_info);
	    Input_info->input_object_1_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'input_object_2'
	 */
	else if ((Input_info->input_object_2_selected)  && (Input_info->input_object_2_optsel))
	{
	    Input_input_object_2(Input_info);
	    Input_info->input_object_2_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'input_object_3'
	 */
	else if ((Input_info->input_object_3_selected)  && (Input_info->input_object_3_optsel))
	{
	    Input_input_object_3(Input_info);
	    Input_info->input_object_3_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'input_object_4'
	 */
	else if ((Input_info->input_object_4_selected)  && (Input_info->input_object_4_optsel))
	{
	    Input_input_object_4(Input_info);
	    Input_info->input_object_4_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Output
| 
|       Purpose: GUI Driver for pane 'Output'
| 
|         Input: form - pointer to the form tree
|                Output_info - pointer to RenderMonster_Output struct
| 
|        Output: None
|    Written By: conductor -program_name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Output(
     RenderMonster_Output *Output_info)

{

	/*
	 * user selected 'live' output file selection 'output_image_fname'
	 */
	if ((Output_info->output_image_fname_selected)  && (Output_info->output_image_fname_optsel))
	{
	    Output_output_image_fname(Output_info);
	    Output_info->output_image_fname_selected = FALSE;
	}


}


