 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Output
   >>>> 
   >>>>  Private: 
   >>>> 	Output_output_image_fname
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

/*-----------------------------------------------------------
| 
|  Routine Name: Output_output_image_fname
| 
|       Purpose: Do routine which is called when
|                  output selection output_image_fname is used
| 
|         Input: Output_info - ptr to PaneInfo struct for Output pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Output_output_image_fname(
     RenderMonster_Output *Output_info)
{
    /* PUT YOUR CODE HERE ! */
    set_do_named_output(TRUE);
    set_output_transport_name(Output_info->output_image_fname);
    reinit_output_object(FALSE, TRUE);
}


void
init_output_pane_GUI(clui_info_struct *cli,
                     RenderMonster_Output *ri)
{
    if (cli->o_flag)
    {
        xvf_set_attribute(ri->output_image_fname_struct,
                          XVF_FILE_NAME,
                          cli->o_file);
        xvf_set_attribute(ri->output_image_fname_struct,
                          XVF_ACTIVATE,
                          TRUE);
        xvf_set_attribute(ri->output_image_fname_struct,
                          XVF_OPTSEL,
                          TRUE);
    }
}


