 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Input
   >>>> 
   >>>>  Private: 
   >>>> 	Input_input_object_1
   >>>> 	Input_input_object_2
   >>>> 	Input_input_object_3
   >>>> 	Input_input_object_4
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

/** HACK to support file detect from this neck of the woods. **/
static int i_zero=0,i_one=1,i_two=2,i_three=3;
static float fdetect_wait_time = 2.0;
int reread_input_object PROTO((xvobject, char *, kaddr));  

/*-----------------------------------------------------------
| 
|  Routine Name: Input_input_object_1
| 
|       Purpose: Do routine which is called when
|                  input selection input_object_1 is used
| 
|         Input: Input_info - ptr to PaneInfo struct for Input pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Input_input_object_1(
     RenderMonster_Input *Input_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *t;
    int status;

    t = create_rmonsterobj();
    status = convert_kobj_to_rmonsterobj(Input_info->input_object_1,t);
    if (status == CHILL)
    {
        replace_input_object(0,t);
        xvw_add_detectfile(NULL,Input_info->input_object_1,fdetect_wait_time,
                           reread_input_object,&i_zero);
    }
}


/*-----------------------------------------------------------
| 
|  Routine Name: Input_input_object_2
| 
|       Purpose: Do routine which is called when
|                  input selection input_object_2 is used
| 
|         Input: Input_info - ptr to PaneInfo struct for Input pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Input_input_object_2(
     RenderMonster_Input *Input_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *t;
    int status;

    t = create_rmonsterobj();
    status = convert_kobj_to_rmonsterobj(Input_info->input_object_2,t);
    if (status == CHILL)
    {
        replace_input_object(1,t);
        xvw_add_detectfile(NULL,Input_info->input_object_2,fdetect_wait_time,
                           reread_input_object,&i_one);
    }
}


/*-----------------------------------------------------------
| 
|  Routine Name: Input_input_object_3
| 
|       Purpose: Do routine which is called when
|                  input selection input_object_3 is used
| 
|         Input: Input_info - ptr to PaneInfo struct for Input pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Input_input_object_3(
     RenderMonster_Input *Input_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *t;
    int status;

    t = create_rmonsterobj();
    status = convert_kobj_to_rmonsterobj(Input_info->input_object_3,t);
    if (status == CHILL)
    {
        replace_input_object(2,t);
        xvw_add_detectfile(NULL,Input_info->input_object_3,fdetect_wait_time,
                           reread_input_object,&i_two);
    }
}


/*-----------------------------------------------------------
| 
|  Routine Name: Input_input_object_4
| 
|       Purpose: Do routine which is called when
|                  input selection input_object_4 is used
| 
|         Input: Input_info - ptr to PaneInfo struct for Input pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Input_input_object_4(
     RenderMonster_Input *Input_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *t;
    int status;

    t = create_rmonsterobj();
    status = convert_kobj_to_rmonsterobj(Input_info->input_object_4,t);
    if (status == CHILL)
    {
        replace_input_object(3,t);
        xvw_add_detectfile(NULL,Input_info->input_object_4,fdetect_wait_time,
                           reread_input_object,&i_three);
    }
}

void
init_input_pane_GUI(clui_info_struct *cli,
                    RenderMonster_Input *ri)
{
    /* put some filenames into the slots on the Input form */
    if (cli->i1_flag)
    {
        xvf_set_attribute(ri->input_object_1_struct,
                          XVF_FILE_NAME,
                          cli->i1_file);
        xvf_set_attribute(ri->input_object_1_struct,
                          XVF_ACTIVATE,
                          TRUE);
        xvf_set_attribute(ri->input_object_1_struct,
                          XVF_OPTSEL,
                          TRUE);
    }
    if (cli->i2_flag)
    {
        xvf_set_attribute(ri->input_object_2_struct,
                          XVF_FILE_NAME,
                          cli->i2_file);
        xvf_set_attribute(ri->input_object_2_struct,
                          XVF_ACTIVATE,
                          TRUE);
        xvf_set_attribute(ri->input_object_2_struct,
                          XVF_OPTSEL,
                          TRUE);
    }
    if (cli->i3_flag)
    {
        xvf_set_attribute(ri->input_object_3_struct,
                          XVF_FILE_NAME,
                          cli->i3_file);
        xvf_set_attribute(ri->input_object_3_struct,
                          XVF_ACTIVATE,
                          TRUE);
        xvf_set_attribute(ri->input_object_3_struct,
                          XVF_OPTSEL,
                          TRUE);
    }
    if (cli->i4_flag)
    {
        xvf_set_attribute(ri->input_object_4_struct,
                          XVF_FILE_NAME,
                          cli->i4_file);
        xvf_set_attribute(ri->input_object_4_struct,
                          XVF_ACTIVATE,
                          TRUE);
        xvf_set_attribute(ri->input_object_4_struct,
                          XVF_OPTSEL,
                          TRUE);
    }
}
