 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for glinexyz
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lglinexyz
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
#include "internals.h"
static void get_segments		PROTO((int , kfile *, kobject , int,
					       vertex_3d *, vertex_3d *, int));
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lglinexyz - *
* 
*       Purpose: This should be a complete description that anyone
*                could understand;  it should have acceptable grammar
*                and correct spelling.
*
*         Input: argument1 - explanation
*                argument2 - explanation
*                argument3 - explanation
*
*        Output: argument4 - explanation
*                argument5 - explanation
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: 
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lglinexyz(kfile *infile,
	      kobject outobj,
	      char *name,
	      int close_region)
/* -library_def_end */

/* -library_code */
{
    int nsegs,seq_no;
    int i;
    vertex_3d bmin,bmax,center;
    char buffer[256];
    
    /* set up the output object */
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NAME,name);
    kgeom_create_primitive_list(outobj);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,1);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_LAYOUT,KPER_VERTEX);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_HAS_ALPHA,TRUE);
    
    lset_common_geom_attributes(outobj);

    kfgets(buffer, KLENGTH, infile);
    ksscanf(buffer,"%d",&nsegs);
    
    seq_no = 0;

    for (i=0;i<3;i++)
    {
	bmin.v[i] = KGEOM_BIGNUM;
	bmax.v[i] = KGEOM_SMALLNUM;
    }
    
    while (!kfeof(infile))
    {
	get_segments(nsegs,infile,outobj,seq_no,&bmin,&bmax,close_region); 
	kfscanf(infile,"%d",&nsegs);
	seq_no++;
    }

    for (i=0;i<3;i++)
	center.v[i] = bmin.v[i] + (bmax.v[i] - bmin.v[i]) * 0.5;


    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_BOUNDING_BOX,&(bmin.v[0]),&(bmax.v[0]));
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_CENTER,&(center.v[0]));

    return TRUE;
}

static void
get_segments(int nverts,
	     kfile *infile,
	     kobject outobj,
	     int prim_no,
	     vertex_3d *min,
	     vertex_3d *max,
	     int close_region)
{
    int i,j;
    vertex_3d *v,*v1;
    vertex_3d loc_min,loc_max;

    v = v1 = kmalloc(sizeof(vertex_3d)*((close_region == 0) ?nverts:nverts+1));
    
    for (i=0;i<nverts;i++,v++)
    {
	kfscanf(infile,"%f %f %f",&(v->v[0]),&(v->v[1]),&(v->v[2]));
#if 0
	for (j=0;j<3;j++)
	{
	    if (v->v[j] > max->v[j])
		max->v[j] = v->v[j];
	    if (v->v[j] < min->v[j])
		min->v[j] = v->v[j];
	}
#endif
    }

    if (close_region == 1)
	v1[nverts] = v1[0];

    lcompute_bbox(v1,nverts,&loc_min,&loc_max);
    lunion_boxes(min,max,&loc_min,&loc_max,min,max);
    
    
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,prim_no+1);
    kgeom_set_attribute(outobj,KGEOM_POLYLINE_CONNECTED,KGEOM_NUMBER_VERTICES,
			((close_region == 1) ? nverts+1 : nverts));
    kgeom_put_data(outobj,KGEOM_POLYLINE_CONNECTED,v1,NULL);

    kfree(v1);
}
/* -library_code_end */
