 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gquadmesh
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gquadmesh.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Create a Quadmesh Geometry Object from 2D Data
|
|       Purpose: main program for gquadmesh
|
|         Input:
|		char *clui_info->i_file; {input 2d data for quadmesh}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {ouput geometry quadmesh}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|		Optional M.E. group:
|		    char *clui_info->cmap_file; {input vis colormap}
|		    int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		    M.I. group:
|			int clui_info->tc2d_flag; {TRUE if -tc2d specified}
|
|			double clui_info->umin2d_double; {umin}
|			int    clui_info->umin2d_flag; {TRUE if -umin2d specified}
|
|			double clui_info->umax2d_double; {umax}
|			int    clui_info->umax2d_flag; {TRUE if -umax2d specified}
|
|			double clui_info->vmin2d_double; {vmin}
|			int    clui_info->vmin2d_flag; {TRUE if -vmin2d specified}
|
|			double clui_info->vmax2d_double; {vmax}
|			int    clui_info->vmax2d_flag; {TRUE if -vmax2d specified}
|
|		    M.I. group:
|			int clui_info->tc3d_flag; {TRUE if -tc3d specified}
|
|			double clui_info->umin3d_double; {umin}
|			int    clui_info->umin3d_flag; {TRUE if -umin3d specified}
|
|			double clui_info->umax3d_double; {umax}
|			int    clui_info->umax3d_flag; {TRUE if -umax3d specified}
|
|			double clui_info->vmin3d_double; {vmin}
|			int    clui_info->vmin3d_flag; {TRUE if -vmin3d specified}
|
|			double clui_info->vmax3d_double; {vmax}
|			int    clui_info->vmax3d_flag; {TRUE if -vmax3d specified}
|
|			double clui_info->wmin3d_double; {wmin}
|			int    clui_info->wmin3d_flag; {TRUE if -wmin3d specified}
|
|			double clui_info->wmax3d_double; {wmax}
|			int    clui_info->wmax3d_flag; {TRUE if -wmax3d specified}
|
|        Output:
|       Returns:
|
|    Written By: Yo Momma
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject inobj,outobj,cmapobj;
	int have_mapfile,have_tcoords;
	float tc[4];
	char *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gquadmesh_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gquadmesh",
		gquadmesh_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gquadmesh_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	have_tcoords = 0;
	have_mapfile = 0;
	inobj = kpds_open_object(clui_info->i_file,KOBJ_READ);
	outobj = kgeom_open_object(clui_info->o_file,KOBJ_WRITE);
	if (clui_info->cmap_flag)
        {
	    cmapobj = kpds_open_object(clui_info->cmap_file,KOBJ_READ);
	    have_mapfile = TRUE;
	}
	else
	{
	    have_mapfile = FALSE;

	    if (clui_info->tc2d_flag)
	    {
		have_tcoords = 2;
		tc[0] = clui_info->umin2d_double;
		tc[1] = clui_info->umax2d_double;
		tc[2] = clui_info->vmin2d_double;
		tc[3] = clui_info->vmax2d_double;
	    }
	    if (clui_info->tc3d_flag)
	    {
		have_tcoords = 3;
		tc[0] = clui_info->umin3d_double;
		tc[1] = clui_info->umax3d_double;
		tc[2] = clui_info->vmin3d_double;
		tc[3] = clui_info->vmax3d_double;
		tc[4] = clui_info->wmin3d_double;
		tc[5] = clui_info->wmax3d_double;
	    }
	}

	name = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
	lgquadmesh(inobj,have_mapfile,cmapobj,outobj,name,
		  have_tcoords,tc);
/* -main_library_call_end */

/* -main_after_lib_call */
	kpds_close_object(inobj);
	kgeom_close_object(outobj);
	if (have_mapfile == TRUE)
	    kpds_close_object(cmapobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gquadmesh_usage_additions
| 
|       Purpose: Prints usage additions in gquadmesh_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gquadmesh
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gquadmesh_usage_additions(void)
{
	kfprintf(kstderr, "\tCreate a Quadmesh Geometry Object from 2D Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gquadmesh_free_args
| 
|       Purpose: Frees CLUI struct allocated in gquadmesh_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gquadmesh
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gquadmesh_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
	kfree(clui_info->cmap_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
