 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for glinexyz
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "glinexyz.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Create Polylines from ASCII XYZ Data
|
|       Purpose: main program for glinexyz
|
|         Input:
|		char *clui_info->i_file; {input ASCII data containing polyline points}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|		int clui_info->close_logic; {connect first and last points in list of vertices.}
|		int clui_info->close_flag; {TRUE if -close specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject outobj;
	kfile *inobj;
	char *name;
	int close_region;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(glinexyz_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "glinexyz",
		glinexyz_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	glinexyz_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	inobj = kfopen(clui_info->i_file,"r");
	if (inobj == NULL)
	{
	    kerror(NULL,"main","can't open the requested input file: <%s>",clui_info->i_file);
	    kexit(KEXIT_FAILURE);
	}
	outobj = kgeom_open_object(clui_info->o_file,KOBJ_WRITE);

	name = clui_info->name_string;
	close_region = clui_info->close_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
	lglinexyz(inobj,outobj,name,close_region);
/* -main_library_call_end */

/* -main_after_lib_call */
	kfclose(inobj);
	kpds_close_object(outobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: glinexyz_usage_additions
| 
|       Purpose: Prints usage additions in glinexyz_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname glinexyz
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void glinexyz_usage_additions(void)
{
	kfprintf(kstderr, "\tCreate Polylines from ASCII XYZ Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: glinexyz_free_args
| 
|       Purpose: Frees CLUI struct allocated in glinexyz_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname glinexyz
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
glinexyz_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
