
/*********************************************************************

Copyright (C) 1993, 1994, 1995,  Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/


#include "geometry/geometry.h"
#include "gisosurface.h"
#include "cell_table.h"

/* protos for this file */
double GET_T PROTO((double, double, double));

void generate_triangles PROTO((int,int,int,int,kobject,slice *,slice *,slice *,slice *,double,int,int));

static void compute_normal PROTO((vertex *,int,int,int,int,int,slice *,slice *,slice *,slice *, int));


/* needed protos for iso_main.c file  */
/* void add_triangle PROTO((vertex *, vertex *, kobject, int)); */
void add_triangle PROTO((vertex **, vertex **, kobject, int));

/*
#define GET_T(d1,d2,t) ((t-d1)/(d2-d1))
*/

double
GET_T(double d1,
      double d2,
      double t)
{
    double p;
    p = 1./(d2-d1);
    p = (t-d1)*p;
    if ((p > 1.) || (p < 0.))
	kfprintf(kstderr,"parametric value out of range.\n");
    
    return(p);
}

static float crossings[13][3];
static float grad[13][3];

void
generate_triangles(int index,
		   int ui,
		   int vi,
		   int wi,
		   kobject isosurf,
		   slice *slice_prev,
		   slice *slice0,
		   slice *slice1,
		   slice *slice_next,
		   double level,
		   int do_normals,
		   int flip_normals)
{
    int i,nedges,current_edge;
    double data1,data2,data3,data4;
    double data5,data6,data7,data8;
    double *dd;
    vertex norm1,norm2,geom1,geom2;
    int usize,vsize;

    double x1,x2,y1,y2,z1,z2;
    float *p;
    double parametric_loc;
    float verts[3][3];
    float norms[3][3];

    int npolys,j,index2;

    data1 = slice0->data[vi][ui];
    data2 = slice0->data[vi][ui+1];
    data3 = slice0->data[vi+1][ui+1];
    data4 = slice0->data[vi+1][ui];

    data5 = slice1->data[vi][ui];
    data6 = slice1->data[vi][ui+1];
    data7 = slice1->data[vi+1][ui+1];
    data8 = slice1->data[vi+1][ui];

    usize = slice0->usize;
    vsize = slice0->vsize;
    
    nedges = cell_table[index].nedges;

    for (i=0;i<nedges;i++)
    {
	current_edge = cell_table[index].edges[i];
	switch (current_edge)
	{
	case 1:
	    x1 = slice0->xpts[vi][ui];
	    x2 = slice0->xpts[vi][ui+1];
	    y1 = slice0->ypts[vi][ui];
	    y2 = slice0->ypts[vi][ui+1];
	    z1 = slice0->zpts[vi][ui];
	    z2 = slice0->zpts[vi][ui+1];
	    
	    if (data2 == data1)
		crossings[1][0] = x1;
	    else
	    {
		parametric_loc = GET_T(data1,data2,level);
		crossings[1][0] = x1 + parametric_loc * (x2-x1);
	    }
	    
	    crossings[1][1] = y1+parametric_loc*(y2-y1); 
	    crossings[1][2] = z1+parametric_loc*(z2-z1);

	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[1][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[1][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[1][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	    
	case 2:
	    x1 = slice0->xpts[vi][ui+1];
	    x2 = slice0->xpts[vi+1][ui+1];
	    y1 = slice0->ypts[vi][ui+1];
	    y2 = slice0->ypts[vi+1][ui+1];
	    z1 = slice0->zpts[vi][ui+1];
	    z2 = slice0->zpts[vi+1][ui+1];
	    
	    if (data3 == data2)
		crossings[2][1] = y1;
	    else
	    {
		parametric_loc = GET_T(data2,data3,level);
		crossings[2][1] = y1 + parametric_loc * (y2 - y1);
	    }
	    crossings[2][0] = x1 + parametric_loc * (x2 - x1); /* x2 */
	    crossings[2][2] = z1 + parametric_loc * (z2 - z1); 

	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[2][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[2][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[2][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	    
	case 3:
	    x1 = slice0->xpts[vi+1][ui+1];
	    x2 = slice0->xpts[vi+1][ui];
	    y1 = slice0->ypts[vi+1][ui+1];
	    y2 = slice0->ypts[vi+1][ui];
	    z1 = slice0->zpts[vi+1][ui+1];
	    z2 = slice0->zpts[vi+1][ui];
	    
	    if (data3 == data4)
		crossings[3][0] = x1;
	    else
	    {
		parametric_loc = GET_T(data3,data4,level);
		crossings[3][0] = x1 + parametric_loc * (x2 - x1);
	    }
	    
	    crossings[3][1] = y1+parametric_loc*(y2-y1);  /* y2 in paper */
	    crossings[3][2] = z1+parametric_loc*(z2-z1);

	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[3][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[3][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[3][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	    
	case 4:
	    x1 = slice0->xpts[vi+1][ui];
	    x2 = slice0->xpts[vi][ui];
	    y1 = slice0->ypts[vi+1][ui];
	    y2 = slice0->ypts[vi][ui];
	    z1 = slice0->zpts[vi+1][ui];
	    z2 = slice0->zpts[vi][ui];
		
	    if (data4 == data1)
		crossings[4][1] = y1;
	    else
	    {
		parametric_loc = GET_T(data4,data1,level);
		crossings[4][1] = y1 + parametric_loc * (y2 - y1);
	    }

	    crossings[4][0] = x1 + parametric_loc *(x2-x1);
	    crossings[4][2] = z1 + parametric_loc *(z2-z1);
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[4][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[4][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[4][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    
	    break;
	    
	case 5:
	    x1 = slice1->xpts[vi][ui];
	    x2 = slice1->xpts[vi][ui+1];
	    y1 = slice1->ypts[vi][ui];
	    y2 = slice1->ypts[vi][ui+1];
	    z1 = slice1->zpts[vi][ui];
	    z2 = slice1->zpts[vi][ui+1];
	    
	    if (data6 == data5)
		crossings[5][0] = x1;
	    else
	    {
		parametric_loc = GET_T(data5,data6,level);
		crossings[5][0] = x1 + parametric_loc * (x2 - x1);
	    }

	    crossings[5][1] = y1+parametric_loc*(y2-y1); 
	    crossings[5][2] = z1+parametric_loc*(z2-z1); /* z2 in paper */
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[5][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[5][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[5][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    
	    break;
	    
	case 6:
	    x1 = slice1->xpts[vi][ui+1];
	    x2 = slice1->xpts[vi+1][ui+1];
	    y1 = slice1->ypts[vi][ui+1];
	    y2 = slice1->ypts[vi+1][ui+1];
	    z1 = slice1->zpts[vi][ui+1];
	    z2 = slice1->zpts[vi+1][ui+1];
	    
	    if (data7 == data6)
		crossings[6][1] = y1;
	    else
	    {
		parametric_loc = GET_T(data6,data7,level);
		crossings[6][1] = y1 + parametric_loc * (y2 - y1);
	    }
	    crossings[6][0] = x1+parametric_loc*(x2-x1); /* x2 in paper */
	    crossings[6][2] = z1+parametric_loc*(z2-z1); /* z2 in paper */
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[6][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[6][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[6][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    
	    break;
	    
	case 7:
	    x1 = slice1->xpts[vi+1][ui+1];
	    x2 = slice1->xpts[vi+1][ui];
	    y1 = slice1->ypts[vi+1][ui+1];
	    y2 = slice1->ypts[vi+1][ui];
	    z1 = slice1->zpts[vi+1][ui+1];
	    z2 = slice1->zpts[vi+1][ui];
	    
	    if (data7 == data8)
		crossings[7][0] = x1;
	    else
	    {
		parametric_loc = GET_T(data7,data8,level); 
		crossings[7][0] = x1 + parametric_loc * (x2 - x1);
	    }
	    crossings[7][1] = y1+parametric_loc*(y2-y1); /* y2 in paper */
	    crossings[7][2] = z1+parametric_loc*(z2-z1); /* z2 in paper */
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[7][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[7][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[7][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    
	    break;
	    
	case 8:
	    x1 = slice1->xpts[vi+1][ui];
	    x2 = slice1->xpts[vi][ui];
	    y1 = slice1->ypts[vi+1][ui];
	    y2 = slice1->ypts[vi][ui];
	    z1 = slice1->zpts[vi+1][ui];
	    z2 = slice1->zpts[vi][ui];
	    
	    if (data8 == data5)
		crossings[8][1] = y1;
	    else
	    {
		parametric_loc = GET_T(data8,data5,level);
		crossings[8][1] = y1 + parametric_loc * (y2 - y1);
	    }
	    
	    crossings[8][0] = x1+parametric_loc*(x2-x1); 
	    crossings[8][2] = z1+parametric_loc*(z2-z1); /* z2 in paper */

	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[8][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[8][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[8][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    
	    
	    break;
	    
	case 9:
	    x1 = slice0->xpts[vi][ui];
	    x2 = slice1->xpts[vi][ui];	
	    y1 = slice0->ypts[vi][ui];
	    y2 = slice1->ypts[vi][ui];
	    z1 = slice0->zpts[vi][ui];
	    z2 = slice1->zpts[vi][ui];
    
	    if (data5 == data1)
		crossings[9][2] = z1;
	    else
	    {
		parametric_loc = GET_T(data1,data5,level);
		crossings[9][2] = z1 + parametric_loc * (z2 - z1);
	    }

	    crossings[9][1] = y1 + parametric_loc*(y2-y1);
	    crossings[9][0] = x1 + parametric_loc*(x2-x1);
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[9][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[9][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[9][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	    
	case 10:
	    x1 = slice0->xpts[vi][ui+1];
	    x2 = slice1->xpts[vi][ui+1];
	    y1 = slice0->ypts[vi][ui+1];
	    y2 = slice1->ypts[vi][ui+1];
	    z1 = slice0->zpts[vi][ui+1];
	    z2 = slice1->zpts[vi][ui+1];
	    
	    if (data6 == data2)
		crossings[10][2] = z1;
	    else
	    {
		parametric_loc = GET_T(data2,data6,level);
		crossings[10][2] = z1 + parametric_loc * (z2 - z1);
	    }

	    crossings[10][1] = y1+parametric_loc*(y2-y1); 
	    crossings[10][0] = x1+parametric_loc*(x2-x1);  /* x2 in paper */
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[10][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[10][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[10][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }

	    break;
	case 11:
	    x1 = slice0->xpts[vi+1][ui];
	    x2 = slice1->xpts[vi+1][ui];
	    y1 = slice0->ypts[vi+1][ui];
	    y2 = slice1->ypts[vi+1][ui];
	    z1 = slice0->zpts[vi+1][ui];
	    z2 = slice1->zpts[vi+1][ui];
	    
	    if (data8 == data4)
		crossings[11][2] = z1;
	    else
	    {
		parametric_loc = GET_T(data4,data8,level);
		crossings[11][2] = z1 + parametric_loc * (z2 - z1);
	    }

	    crossings[11][1] = y1+parametric_loc*(y2-y1); /* y2 in paper */
	    crossings[11][0] = x1+parametric_loc*(x2-x1);
	    
	    if (do_normals)
	    {
		compute_normal(&norm1,ui,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[11][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[11][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[11][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	    
	case 12:
	    x1 = slice0->xpts[vi+1][ui+1];
	    x2 = slice1->xpts[vi+1][ui+1];
	    y1 = slice0->ypts[vi+1][ui+1];
	    y2 = slice1->ypts[vi+1][ui+1];
	    z1 = slice0->zpts[vi+1][ui+1];
	    z2 = slice1->zpts[vi+1][ui+1];
	    
	    if (data7 == data3)
		crossings[12][2] = z1;
	    else
	    {
		parametric_loc = GET_T(data3,data7,level);
		crossings[12][2] = z1 + parametric_loc * (z2 - z1);
	    }
	    crossings[12][1] = y1+parametric_loc*(y2-y1);  /* y2 in paper */
	    crossings[12][0] = x1+parametric_loc*(x2-x1); /* x2 in paper */

	    if (do_normals)
	    {
		compute_normal(&norm1,ui+1,vi+1,0,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		compute_normal(&norm2,ui+1,vi+1,1,usize,vsize,slice_prev,slice0,slice1,slice_next,flip_normals);
		grad[12][0] = norm1.x + parametric_loc*(norm2.x - norm1.x);
		grad[12][1] = norm1.y + parametric_loc*(norm2.y - norm1.y);
		grad[12][2] = norm1.z + parametric_loc*(norm2.z - norm1.z);
	    }
	    break;
	}
    }

    npolys = cell_table[index].npolys;
    index2 = 0;

    {
	vertex *l_vlist[3];	/* pointers to 3 triangle vertices */
	vertex *l_nlist[3];	/* pointers to 3 vertex normals */

	for (i=0;i<npolys;i++)
	{
	    l_vlist[0] = (vertex *)&crossings[cell_table[index].polys[index2]][0];

	    if (do_normals)
		l_nlist[0] = (vertex *)&grad[cell_table[index].polys[index2]][0];
	    index2++;

	    l_vlist[1] = (vertex *)&crossings[cell_table[index].polys[index2]][0];
	    
	    if (do_normals)
		l_nlist[1] = (vertex *)&grad[cell_table[index].polys[index2]][0];

	    index2++;

	    l_vlist[2] = (vertex *)&crossings[cell_table[index].polys[index2]][0];
	    if (do_normals)
		l_nlist[2] = (vertex *)&grad[cell_table[index].polys[index2]][0];
	    index2++;
	
#if 0
	    /*  */
	    kfprintf(stderr,"\ttriangle:\n\t");
	    
	    for(j=0;j<3;j++)
	    {
		kfprintf(stderr,"\t%g %g %g",l_vlist[i].x,l_vlist[i].y,l_vlist[i].z);
		if (do_normals)
		    kfprintf(stderr,"\tnormal:\t%g %g %g",l_nlist[i].x,l_nlist[i].y,l_nlist[i].z);
		kfprintf(stderr,"\n");
	    }
#endif
	    add_triangle(l_vlist,l_nlist,isosurf,do_normals);
	}
    }
}


static void
compute_normal(vertex *norm,
	       int ui,
	       int vi,
	       int wi,
	       int usize,
	       int vsize,
	       slice *slice_prev,
	       slice *slice0,
	       slice *slice1,
	       slice *slice_next,
	       int flip_normals)
{
    int i_minus,i_plus,j_minus,j_plus,k_minus,k_plus;
    vertex data,geom;
    slice *sp0,*sp1,*sp2;
    double mag;
    double sign;
    
    if (wi == 0)
    {
	sp0 = slice_prev;
	sp1 = slice0;
	sp2 = slice1;
    }
    else
    {
	sp0 = slice0;
	sp1 = slice1;
	sp2 = slice_next;
    }

    i_plus = (ui==usize-1) ? usize-1 : ui+1;
    i_minus = (ui == 0) ? 0 : ui-1;
    j_plus = (vi == vsize-1) ? vsize-1 : vi+1;
    j_minus = (vi == 0) ? 0 : vi-1;

    data.x = sp1->data[vi][i_plus] - sp1->data[vi][i_minus];
    data.y = sp1->data[j_plus][ui] - sp1->data[j_minus][ui];
    data.z = sp2->data[vi][ui] - sp0->data[vi][ui];
    
    geom.x = sp1->xpts[vi][i_plus] - sp1->xpts[vi][i_minus];
    geom.y = sp1->ypts[j_plus][ui] - sp1->ypts[j_minus][ui];
    geom.z = sp2->zpts[vi][ui] - sp0->zpts[vi][ui];

    if (flip_normals)
	sign = -1.;
    else
	sign = 1.;
    
    if (geom.x != 0.)
	norm->x = data.x / geom.x;
    else
	norm->x = 0.;

    if (geom.y != 0.)
	norm->y = data.y / geom.y;
    else
	norm->y = 0.;

    if (geom.z != 0.)
	norm->z = data.z / geom.z;
    else
	norm->z = 0.;

    mag = norm->x * norm->x + norm->y * norm->y + norm->z * norm->z;
    if (mag != 0.)
    {
	mag = ksqrt(mag);
	mag = 1./mag;
	norm->x *= mag * sign;
	norm->y *= mag * sign;
	norm->z *= mag * sign;
    }
}
