 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for gisosurface
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 12, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _gisosurface_h_
#define _gisosurface_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/gisosurface/uis/gisosurface.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input 3d data object (required infile)
 */
char	*i_file;	/* input 3d data object FILENAME */
int	 i_flag;	/* input 3d data object FLAG */

/*
 *  contouring level (required float)
 */
float	 l_float;	/* contouring level FLOAT */
int	 l_flag;   	/* contouring level FLAG */

/*
 *  output geometry object (required outfile)
 */
char	*o_file;	/* output geometry object FILENAME */
int	 o_flag;	/* output geometry object FLAG */

/*
 *  compute normals? (optional logical)
 */
int	 normals_logic;	/* compute normals? LOGIC */
int	 normals_flag;  	/* compute normals? FLAG */

/*
 *  reverse normals? (optional logical)
 */
int	 flip_logic;	/* reverse normals? LOGIC */
int	 flip_flag;  	/* reverse normals? FLAG */

/*
 *  object name (optional string)
 */
char	*name_string;	/* object name STRING */
int	 name_flag;   	/* object name FLAG */

} clui_info_struct;

/* -include_typedefs */
typedef struct vertex3d
{
    float x,y,z;
} vertex;

typedef struct slice
{
    int usize,vsize;
/*    vertex **points; */
    float **xpts,**ypts,**zpts;
    double **data;
    unsigned char **mask;
} slice;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void gisosurface_get_args PROTO((kform *));
void gisosurface_usage_additions PROTO((void));
void gisosurface_free_args PROTO((int, kaddr));

/* -include_routines */
void iso_main PROTO((kobject, kobject, double, int, int, char *));
void make_surf PROTO((kobject, kobject, int, int, int, double, int, int));
void load_data_slice PROTO((double *, int, int, int, kobject));
void load_coord_slice PROTO((vertex *, int, int, int, kobject, vertex_3d *, vertex_3d *));
void add_triangle PROTO((vertex **, vertex **, kobject, int));
/* -include_routines_end */

#endif
