 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gisosurface
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gisosurface.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate surface of constant value from 3d data.
|
|       Purpose: main program for gisosurface
|
|         Input:
|		char *clui_info->i_file; {input 3d data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		float clui_info->l_float; {contouring level}
|		int   clui_info->l_flag; {TRUE if -l specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->normals_logic; {compute normals?}
|		int clui_info->normals_flag; {TRUE if -normals specified}
|
|		int clui_info->flip_logic; {reverse normals?}
|		int clui_info->flip_flag; {TRUE if -flip specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject inobj, outobj;
    double threshold;
    int flip_flag,do_normals;
    char *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gisosurface_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gisosurface",
		gisosurface_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gisosurface_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    /**
     * we need to get the input, output objects, and the
     * level to pass to the iso_main() call (below).
     **/
    inobj = kpds_open_input_object(clui_info->i_file);
    outobj = kgeom_open_output_object(clui_info->o_file);

    threshold = clui_info->l_float;
    flip_flag = clui_info->flip_logic;
    do_normals = clui_info->normals_logic;
    name = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
	iso_main(inobj,outobj,threshold,do_normals,flip_flag,name);
/* -main_library_call_end */

/* -main_after_lib_call */
    kpds_close_object(inobj);
    kgeom_close_object(outobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gisosurface_usage_additions
| 
|       Purpose: Prints usage additions in gisosurface_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gisosurface
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gisosurface_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate surface of constant value from 3d data.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gisosurface_free_args
| 
|       Purpose: Frees CLUI struct allocated in gisosurface_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gisosurface
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gisosurface_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
