 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gcolorize
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gcolorize.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Map Value Data Through a Visualization Colormap
|
|       Purpose: main program for gcolorize
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->cmap_file; {input vis colormap}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Steve Kubica
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject data, map, output;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gcolorize_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gcolorize",
		gcolorize_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gcolorize_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((data = kpds_open_input_object(clui_info->i_file))==NULL)
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"gcolorize",
                  "Unable to open input data file %s as a data services object",
                  clui_info->i_file );
           kexit(KEXIT_FAILURE);
        }

        if ((map = kpds_open_input_object(clui_info->cmap_file))==NULL)
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"gcolorize",
                  "Unable to open input map file %s as a data services object",
                  clui_info->cmap_file );
           kpds_close_object(data);
           kexit(KEXIT_FAILURE);
        }

        if ((output = kpds_open_output_object(clui_info->o_file))==NULL)
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"gcolorize",
                  "Unable to open output file %s as a data services object", 
                  clui_info->o_file );

           kpds_close_object(data);
           kpds_close_object(map);
           kexit(KEXIT_FAILURE);
        }
	
	/* -- copy templates over for any segments we may need -- */
	kpds_copy_object_attr(data, output);
	kpds_destroy_map(output);  /* -- except the map -- */
/* -main_before_lib_call_end */

/* -main_library_call */
	lgcolorize( data, map, output );
/* -main_library_call_end */

/* -main_after_lib_call */
	/* -- copy location data -- */
	kpds_copy_remaining_data(data, output);
	
       if (!kpds_close_object(data))
       {
           kerror(NULL,"gcolorize",
                  "Unable to close data file %s", clui_info->i_file );
       }

       if (!kpds_close_object(map))
       {
           kerror(NULL,"gcolorize",
                  "Unable to close map file %s", clui_info->cmap_file );
       }

       if (!kpds_close_object(output))
       {
           kerror(NULL,"gcolorize",
                  "Unable to close output file %s", clui_info->o_file );
       }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gcolorize_usage_additions
| 
|       Purpose: Prints usage additions in gcolorize_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcolorize
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gcolorize_usage_additions(void)
{
	kfprintf(kstderr, "\tMap Value Data Through a Visualization Colormap\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gcolorize_free_args
| 
|       Purpose: Frees CLUI struct allocated in gcolorize_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcolorize
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gcolorize_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->cmap_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
