 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for gcmaplegend
   >>>> 
   >>>>    Written By: Wes Bethel
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _gcmaplegend_h_
#define _gcmaplegend_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include "geometry/geometry.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/gcmaplegend/uis/gcmaplegend.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input vis colormap (required infile)
 */
char	*i_file;	/* input vis colormap FILENAME */
int	 i_flag;	/* input vis colormap FLAG */

/*
 *  output geometry object (required outfile)
 */
char	*o_file;	/* output geometry object FILENAME */
int	 o_flag;	/* output geometry object FLAG */

/*
 *  color legend (optional string)
 */
char	*name_string;	/* color legend STRING */
int	 name_flag;   	/* color legend FLAG */

/*
 * legend orientation (Optional boolean toggle)
 *	1 (vertical)
 *	2 (horizontal),
 */
int	 orient_toggle;		/* legend orientation LOGICAL TOGGLE */
int	 orient_flag;		/* legend orientation FLAG */

/*
 *  reverse colors? (optional logical)
 */
int	 reverse_logic;	/* reverse colors? LOGIC */
int	 reverse_flag;  	/* reverse colors? FLAG */

/*
 *  make outline? (optional logical)
 */
int	 outline_logic;	/* make outline? LOGIC */
int	 outline_flag;  	/* make outline? FLAG */

/*
 *  length of legend (optional float)
 */
float	 length_float;	/* length of legend FLOAT */
int	 length_flag;   	/* length of legend FLAG */

/*
 *  thickness of legend (optional float)
 */
float	 thickness_float;	/* thickness of legend FLOAT */
int	 thickness_flag;   	/* thickness of legend FLAG */

/*
 *  x position (optional float)
 */
float	 xpos_float;	/* x position FLOAT */
int	 xpos_flag;   	/* x position FLAG */

/*
 *  y position (optional float)
 */
float	 ypos_float;	/* y position FLOAT */
int	 ypos_flag;   	/* y position FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void gcmaplegend_get_args PROTO((kform *));
void gcmaplegend_usage_additions PROTO((void));
void gcmaplegend_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
