 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Xprism Plotting Utilities
   >>>>
   >>>>  Private:
   >>>>             create_plot()
   >>>>		    input_file()
   >>>>		    change_area()
   >>>>		    set_function_pane_gui()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "xprism.h"

static char *colors[] =
{
	"magenta",   "yellow", "blue",   "orange",    "coral",
	"orange",    "wheat",  "lime green",   "turquoise", "pink",
	"lightgrey", "plum",   "forest", "red",	      "salmon",
	"thistle",   "violet", "orangered", "seagreen",
};

static int linetypes[] =
{
	KLINE_SOLID,	  KLINE_DOTTED,
	KLINE_DOT_DASH,  KLINE_SHORT_DASH,
	KLINE_LONG_DASH, KLINE_ODD_DASH,
	KLINE_GRID_DOTTED,
};

static void autocolor_list_cb PROTO((xvobject, kaddr, kaddr));
static void operation_list_cb PROTO((xvobject, kaddr, kaddr));

/*-----------------------------------------------------------
|
|  Routine Name: create_plot - creates a plot within the selected area
|
|       Purpose: This routine is called to create a plot within the selected
|		 area.
|
|         Input: object - the data object
|		 object_type - 2D or 3D or VOLUME
|		 new_area    - whether to plot to a new or existing area
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 03, 1993
| Modifications:
|
------------------------------------------------------------*/

void create_plot(
   kobject object,
   int     object_type,
   int     new_area)
{
	int      num = 0;
	xvobject axis, *children;
	Deflts_deflts     *defaults = gui_info->Deflts->deflts;
	Plot_plot_control *control  = gui_info->Plot->plot_control;
	static int count = 0;


	if (current_area == NULL || new_area == 1)
	{
	   current_area = xvw_create_area(layout, "area");
           xvw_set_attributes(current_area,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.2,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.9,
                NULL);

	   xvw_add_callback(current_area, XVW_DESTROY, update_area_list,
			    NULL);

           xvw_set_attributes(current_area,
		   XVW_AREA_DISPLAY_TITLE, defaults->display_title,
		   XVW_FOREGROUND_COLOR,   defaults->foreground,
		   XVW_BACKGROUND_COLOR,   defaults->background,
		   XVW_AREA_DISPLAY_DATE,  defaults->display_date,
		   NULL);
	   xvw_set_attribute(layout, XVW_LAYOUT_SELECTED_CHILD, current_area);

	   if (object_type == 2)
	   {
              axis = xvw_create_axis2d(current_area, "Axis2d");
              xvw_set_attributes(axis,
                   XVW_AREA_ATTACH, current_area,
                   XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                   XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                   XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.2,
                   XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                   XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                   XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.9,
                   NULL);
	      xvw_add_callback(axis, XVW_DESTROY, update_plot_list, NULL);
	   }
	   else axis = NULL;
	}
	else
	{
	   if ((children = xvw_children(current_area, Axis2DGadgetClass,
				NULL)) != NULL)
	   {
	      axis = children[0];
	      kfree(children);
	   }
	   else
	      axis = NULL;
	}

	num += xvw_numchildren(current_area, Plot2DGadgetClass);
	num += xvw_numchildren(current_area, Plot3DGadgetClass);
	if (object_type == 2)
	{
	   current_plot = xvw_create_plot2d(current_area, "Plot2d");
	   xvw_set_attributes(current_plot,
	        XVW_AREA_ATTACH, current_area,
		XVW_PLOT2D_PLOTOBJ,  object,
		XVW_PLOT2D_PLOTTYPE, control->plot2d_type_val,
		NULL);
	   xvw_add_callback(current_plot, XVW_DESTROY, update_plot_list, NULL);
	}
	else
	{
	   current_plot = xvw_create_plot3d(current_area, "Plot3d");
	   xvw_set_attributes(current_plot,
	        XVW_AREA_ATTACH, current_area,
		XVW_PLOT3D_PLOTOBJ, object,
		XVW_PLOT3D_PLOTTYPE,control->plot3d_type_val-1+KPLOT3D_LINEPLOT,
		NULL);
	   xvw_add_callback(current_plot, XVW_DESTROY, update_plot_list, NULL);
	}
	xvw_set_attributes(current_plot,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.2,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.9,
		NULL);

	if (defaults->new_plot == 1 || defaults->new_plot == 3)
	{
	   xvw_set_attribute(current_plot, XVW_FOREGROUND_COLOR,
			colors[num % knumber(colors)]);
	}

	if (defaults->new_plot == 2 || defaults->new_plot == 3)
	{
	   xvw_set_attribute(current_plot, XVW_GRAPHICS_LINETYPE,
			linetypes[num % knumber(linetypes)]);
	}
	change_area(layout, NULL, &current_area);

	if (count == 0)
	   init_colormap_display(object);
	count++;
}

/*-----------------------------------------------------------
| 
|  Routine Name: input_file
| 
|       Purpose: routine which is called to input a new file
|         Input: filename - 
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/

void input_file(
     char *filename)
{
	kobject object;
	int     w, h, object_type;
	Plot_file *file_info = gui_info->Plot->file;


	if ((object = kpds_open_object(filename, KOBJ_READ)) == NULL)
	{
	   kerror("khoros", "input_file", "Failed to load Plot '%s'", filename);
	   return;
	}

	if (file_info->object_type_val == 1)
	{
	   kpds_get_attribute(object, KPDS_VALUE_SIZE, 
			      &w, &h, NULL, NULL, NULL);
	   if ((w == 1) || (w == 2))
	      object_type = 2;
	   else if (w > 1 && h > 1)
	      object_type = 3;
	   else object_type = 2;
	}
	else
	   object_type = file_info->object_type_val;

	create_plot(object, object_type, file_info->plot_where_val);
	kpds_close_object(object);
}

/*-----------------------------------------------------------
|
|  Routine Name: change_area - change the area currently selected
|			       by the xprism layout object
|
|       Purpose: This routine changes the currently selected area within
|		 the layout object.  We use this info to know which area
|		 the user is currently working.
|
|         Input: object      - the layout object
|                client_data - unused
|                call_data   - the newly selected area
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 03, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void change_area(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	/*
	 *  Quick check to make sure that we are selecting an area...
	 */
	if (!call_data)
	   current_area = NULL;
	else current_area = *((xvobject *) call_data);

	/* callback used here as utility routine */
	update_area_list(NULL, NULL, NULL);

	/* callback used here as utility routine */
	update_plot_list(NULL, NULL, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: set_function_pane_gui
|
|       Purpose: The "Function" pane of the "Plot" subform can work
|                for 2D or 3D plotting.  However, there are lots of
|                selections for 3D plotting that are not wanted when
|                the "Function Dimension" is set to 2D.  This routine
|                unmaps all the selections that apply only to 3D when
|                the user is doing 2D plot functions, maps them
|                when the user is doing 3D functions.
|
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: June 28, 1994
| Modifications:
|
------------------------------------------------------------*/
void set_function_pane_gui(void)
{
	Plot_function *function_info = gui_info->Plot->function;
	xvobject sel_back;
	
       /* 
	* three-D plotting
	*/
	if (function_info->plot_dim == 3)
	{
	
	    /* unmap the string selection for 2D function */
	    sel_back = xvf_get_xvobject(function_info->func_2D_struct,
					    XVF_BACKPLANE, TRUE);
	    xvw_unmap(sel_back);
	    
	    /* unmap the label for 2D function */
	    sel_back = xvf_get_xvobject(function_info->func_2D_blk_struct,
					 XVF_BACKPLANE, TRUE);
	    xvw_unmap(sel_back);

	    /* map the string selection for 3D function */
	    sel_back = xvf_get_xvobject(function_info->func_3D_struct,
					    XVF_BACKPLANE, TRUE);
	    xvw_map(sel_back);
	    
	    /* map the label for 3D function */
	    sel_back = xvf_get_xvobject(function_info->func_3D_blk_struct,
					 XVF_BACKPLANE, TRUE);
	    xvw_map(sel_back);
	
            /* map the label for 'Y' */
            sel_back = xvf_get_xvobject(function_info->Y_blk_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_map(sel_back);

	    /* map the string selection for Y min */
	    sel_back = xvf_get_xvobject(function_info->y_min_struct,
					 XVF_BACKPLANE, TRUE);
	    xvw_map(sel_back);
	
	    /* map the string selection for Y max */
	    sel_back = xvf_get_xvobject(function_info->y_max_struct,
					 XVF_BACKPLANE, TRUE);
	    xvw_map(sel_back);

	    /* map the string selection for Y pts */
	    sel_back = xvf_get_xvobject(function_info->ynum_pts_struct,
					 XVF_BACKPLANE, TRUE);
	    xvw_map(sel_back);
	}

       /* 
	* two-D plotting
	*/
	else
        {

            /* unmap the string selection for 3D function */
            sel_back = xvf_get_xvobject(function_info->func_3D_struct,
                                            XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

            /* unmap the label for 3D function */
            sel_back = xvf_get_xvobject(function_info->func_3D_blk_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

            /* unmap the label for 'Y' */
            sel_back = xvf_get_xvobject(function_info->Y_blk_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

            /* unmap the string selection for Y min */
            sel_back = xvf_get_xvobject(function_info->y_min_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

            /* unmap the string selection for Y max */
            sel_back = xvf_get_xvobject(function_info->y_max_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

            /* unmap the string selection for Y pts */
            sel_back = xvf_get_xvobject(function_info->ynum_pts_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_unmap(sel_back);

	    /* map the string selection for 2D function */
            sel_back = xvf_get_xvobject(function_info->func_2D_struct,
                                            XVF_BACKPLANE, TRUE);
            xvw_map(sel_back);
            
	    /* map the label for 2D function */
            sel_back = xvf_get_xvobject(function_info->func_2D_blk_struct,
                                         XVF_BACKPLANE, TRUE);
            xvw_map(sel_back);
        
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: init_colormap_display
|
|       Purpose: On input of the first plot, gets the autocolor
|                list and the colormap operations list, and
|                sets up the two lists on the colormap display
|                with callbacks that will change the colormap
|                when the user selects one.
|
|         Input: object - the data object assoc w/ input plot
|        Output: none
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
void init_colormap_display(
    kobject data_object)
{
        char     **operation_list, **autocolor_list;
        int      autocolor_num, operation_num;
        xvobject parent, list1, list2, actual_list;

        parent = gui_info->Colormap->colormap->wksp1;
        list1 = xvw_create_list(parent, "Static Autocolor List");
        xvw_set_attributes(list1,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(list1);

        kcolor_get_attribute(data_object, KCOLOR_MAP_AUTOCOLOR_LIST,
                             &autocolor_list, &autocolor_num);
        xvw_change_list(actual_list, autocolor_list, autocolor_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         autocolor_list_cb, NULL);
        xvw_set_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, 0);

        parent = gui_info->Colormap->colormap->wksp2;
        list2 = xvw_create_list(parent, "Dynamic Autocolor List");
        xvw_set_attributes(list2,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(list2);
        kcolor_get_attribute(data_object, KCOLOR_MAP_OPERATION_LIST,
                             &operation_list, &operation_num);
        xvw_change_list(actual_list, operation_list, operation_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         operation_list_cb, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: autocolor_list_cb
|
|       Purpose: Sets the autocolor procedure on the data
|		 object being plotted.
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: August 3, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void autocolor_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int      indx;
	kobject  data_object = NULL;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

	indx = list->list_index;
	if (current_plot == NULL)
	   return;

	xvw_get_attribute(current_plot, XVW_COLOR_COLOROBJ, &data_object);
        kcolor_set_attribute(data_object, KCOLOR_MAP_AUTOCOLOR, indx);
}

/*-----------------------------------------------------------
|
|  Routine Name: operation_list_cb
|
|       Purpose: Sets the colormap operation on the data
|                object being plotted.
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: August 3, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */

static void operation_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int      indx;
	kobject  data_object = NULL;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

        /* #defines for autocolor operations start at 100 */
        indx = list->list_index+100;
	if (current_plot == NULL)
	   return;

	xvw_get_attribute(current_plot, XVW_COLOR_COLOROBJ, &data_object);
        kcolor_set_attribute(data_object, KCOLOR_MAP_OPERATION, indx);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_area_list
|
|       Purpose: This callback is used to update the contents of the 
|	         area list when an area is destroyed.  It is also used 
|                as a utility routine by change_area().
|
|         Input: object      - the area object being destroyed
|	         client_data - not used
|	         call_data   - not used
|        Output: none
|    Written By: Mark Young
|          Date: April 12, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_area_list(
    xvobject area,
    kaddr    client_data,  
    kaddr    call_data)
{
	xvobject *children;
	int      selected, i, num;
	char     temp[KLENGTH]; 
	char     **list = NULL;

	if (area_list == NULL) return;

	selected = -1;
        children = xvw_children(layout, AreaWidgetClass, &num);
        for (i = 0; i < num; i++)
        {
           ksprintf(temp, "Area%d", i+1);
           list = karray_add(list, kstrdup(temp), i);
           if (current_area == children[i])
              selected = i;
        }
        kfree(children);

        xvf_set_attribute(area_list, XVF_LIST_SIZE, num);
        xvf_set_attribute(area_list, XVF_LIST_CONTENTS, list);
        karray_free(list, num, NULL); list = NULL;

        if (selected != -1)
	{
	    xvf_set_attribute(area_list, XVF_LIST_INDEX, selected);
	    gui_info->Options->options->area_list = selected;
	}

}

/*-----------------------------------------------------------
|
|  Routine Name: update_plot_list
|
|       Purpose: This callback is used to update the contents of the 
|                plot list when a plot is destroyed.  It is also used 
|                as a utility routine by change_area().
|
|         Input: object      - the area object being destroyed
|                client_data - not used
|                call_data   - not used
|        Output: none
|    Written By: Mark Young
|          Date: April 12, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_plot_list(
    xvobject area,
    kaddr    client_data,  
    kaddr    call_data)
{
	xvobject *children;
        int      size = 0; 
	int      i, num;
        char     temp[KLENGTH];
        char     **list = NULL;

	if (plot_list == NULL) return;

	if (current_area)
        {
           /*
            *  Create the Axis2d list
            */
           children = xvw_children(current_area, Axis2DGadgetClass, &num);
           for (i = 0; i < num; i++)
           {
              ksprintf(temp, "Axis2D (%d)", i+1);
              list = karray_add(list, kstrdup(temp), size++);
           }
           kfree(children);

           /*
            *  Create the Plot2d list
            */
           children = xvw_children(current_area, Plot2DGadgetClass, &num);
           for (i = 0; i < num; i++)
           {
              ksprintf(temp, "Plot2D (%d)", i+1);
              list = karray_add(list, kstrdup(temp), size++);
           }
           kfree(children);

           /*
            *  Create the Plot2d list
            */
           children = xvw_children(current_area, Plot3DGadgetClass, &num);
           for (i = 0; i < num; i++)
           {
              ksprintf(temp, "Plot3D (%d)", i+1);
              list = karray_add(list, kstrdup(temp), size++);
           }
           kfree(children);
           xvf_set_attribute(plot_list, XVF_LIST_SIZE,     size);
           xvf_set_attribute(plot_list, XVF_LIST_CONTENTS, list);
           xvf_set_attribute(plot_list, XVF_LIST_VAL,      1);
           gui_info->Options->options->plot_list = 1;
	   xvf_set_attribute(gui_info->Options->options->delete_plot_struct,
                              XVF_ACTIVATE, FALSE);
           karray_free(list, size, NULL); list = NULL;
        }
        else
        {
           xvf_set_attribute(plot_list, XVF_LIST_SIZE, 0);
           xvf_set_attribute(plot_list, XVF_LIST_CONTENTS, NULL);
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: quit_cleanup
|
|       Purpose: On area objects and plot objects, there are
|		 callbacks installed (update_area_list() and
|		 update_plot_list() ) that will fire when the
|		 area or plot is destroyed; these look at area_list
|		 and plot_list to update the contents of the lists.  
|		 However, when the user clicks on the "quit" button, 
|		 the area list and plot lists *themselves* have
|		 been destroyed before the callbacks fire.  Unless
|		 we set the area_list and plot_list to NULL here
|		 (which are checked inside the callbacks), a core dump
|		 will occur.
|
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: April 12, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void quit_cleanup(
    kaddr client_data)
{
	area_list = NULL;
	plot_list = NULL;
}


