 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "xprism.h"
/*-----------------------------------------------------------
| 
|  Routine Name: xprism_get_args
| 
|       Purpose: Gets command line args for xprism
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname xprism
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for xprism is out of sync with arguments specified in xprism's *.pane file; please rerun ghostwriter on xprism.";


	/*
	 * allocate the xprism structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i3",
			  &(clui_info->i3_file),
			  &(clui_info->i3_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i4",
			  &(clui_info->i4_file),
			  &(clui_info->i4_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "xprism_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



