 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for master xprism
   >>>> 
   >>>>  Private: 
   >>>> 	xprism_reset_wcs
   >>>> 	xprism_add_indicator
   >>>> 	xprism_remove_area
   >>>> 	xprism_refresh_area
   >>>> 	xprism_clear_layout
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

static void move_indicator PROTO((xvobject, kaddr, XEvent *, int *));

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_reset_wcs
| 
|       Purpose: Do routine which is called when
|                  master action button reset_axis is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_reset_wcs(
     gui_info_struct *master_info)
{
	xvobject *children;
	Coord    wcmin, wcmax, nwcmin, nwcmax;
	int      i, num = 0, initialized = FALSE;


	if (!current_area)
	   return;

	if ((children = xvw_children(current_area, Plot2DGadgetClass, &num)))
	{
	   for (i = 0; i < num; i++)
	   {
	      xvw_get_attributes(children[i],
		XVW_PLOT2D_DATA_MIN_X, &nwcmin.x,
		XVW_PLOT2D_DATA_MIN_Y, &nwcmin.y,
		XVW_PLOT2D_DATA_MAX_X, &nwcmax.x,
		XVW_PLOT2D_DATA_MAX_Y, &nwcmax.y,
		NULL);

	      if (initialized == FALSE)
	      {
	         initialized = TRUE;
	         wcmin.x = nwcmin.x, wcmin.y = nwcmin.y, wcmin.z = 0.0;
	         wcmax.x = nwcmax.x, wcmax.y = nwcmax.y, wcmax.z = 0.0;
	      }
	      else
	      {
	         wcmin.x = kmin(wcmin.x, nwcmin.x);
	         wcmin.y = kmin(wcmin.y, nwcmin.y);
	         wcmax.x = kmax(wcmax.x, nwcmax.x);
	         wcmax.y = kmax(wcmax.y, nwcmax.y);
	      }
	   }
	   kfree(children);
	}

	if ((children = xvw_children(current_area, Plot3DGadgetClass, &num)))
	{
	   for (i = 0; i < num; i++)
	   {
	      xvw_get_attributes(children[i],
		XVW_PLOT3D_DATA_MIN_X, &nwcmin.x,
		XVW_PLOT3D_DATA_MIN_Y, &nwcmin.y,
		XVW_PLOT3D_DATA_MIN_Z, &nwcmin.z,
		XVW_PLOT3D_DATA_MAX_X, &nwcmax.x,
		XVW_PLOT3D_DATA_MAX_Y, &nwcmax.y,
		XVW_PLOT3D_DATA_MAX_Z, &nwcmax.z,
		NULL);

	      if (i == 0)
		 wcmin.z = nwcmin.z, wcmax.z = nwcmax.z;

	      if (initialized == FALSE)
	      {
	         initialized = TRUE;
	         wcmin.x = nwcmin.x, wcmin.y = nwcmin.y, wcmin.z = nwcmin.z;
	         wcmax.x = nwcmax.x, wcmax.y = nwcmax.y, wcmax.z = nwcmax.z;
	      }
	      else
	      {
	         wcmin.x = kmin(wcmin.x, nwcmin.x);
	         wcmin.y = kmin(wcmin.y, nwcmin.y);
	         wcmin.z = kmin(wcmin.z, nwcmin.z);
	         wcmax.x = kmax(wcmax.x, nwcmax.x);
	         wcmax.y = kmax(wcmax.y, nwcmax.y);
	         wcmax.z = kmax(wcmax.z, nwcmax.z);
	      }
	   }
	   kfree(children);
	}

	if (initialized == TRUE)
	{
	   xvw_set_attributes(current_area,
		XVW_GRAPHICS_WCMIN_X, wcmin.x,
		XVW_GRAPHICS_WCMIN_Y, wcmin.y,
		XVW_GRAPHICS_WCMIN_Z, wcmin.z,
		XVW_GRAPHICS_WCMAX_X, wcmax.x,
		XVW_GRAPHICS_WCMAX_Y, wcmax.y,
		XVW_GRAPHICS_WCMAX_Z, wcmax.z,
		NULL);
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_add_indicator
| 
|       Purpose: Do routine which is called when
|                  master action button add_indicator is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_add_indicator(
     gui_info_struct *master_info)
{
	xvobject indicator;
	int      num;
	unsigned int w, h;
	xvobject *children;
	xvobject current_axis = NULL;

	if (!current_area)
	   return;

	/* find axis of current area */
	if ((children = xvw_children(current_area, Axis2DGadgetClass, 
			             &num)) != NULL)
        {
           current_axis  = children[0];
           kfree(children);
        }
	else 
	{
	   kerror(NULL, "xprism_add_indicator", 
		 "Currently selected area does not contain 2D Plots/Axes; indicators only work with 2D."); 
           return;
	}

	indicator = xvw_create_indicator(current_area, "indicator");
	xvw_geometry(current_area, NULL, NULL, &w, &h, NULL);

	if (current_area != NULL)
	    xvw_set_attribute(indicator, XVW_AREA_ATTACH, current_axis);

	xvw_set_attributes(indicator,
		           XVW_XPOSITION, w/2,
		           XVW_YPOSITION, h/2,
		           NULL);

	/* add event handler to area object to allow user to move indicator */
        xvw_add_event(indicator, ButtonMotionMask, move_indicator, NULL);

}

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_remove_area
| 
|       Purpose: Do routine which is called when
|                  master action button remove_area is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_remove_area(
     gui_info_struct *master_info)
{
	xvobject *children;

	if (!current_area)
	   return;

	xvw_destroy(current_area);
        if ((children = xvw_children(layout, AreaWidgetClass, NULL)) != NULL)
	{
	   current_area = children[0];
	   kfree(children);
	}
        else current_area = NULL;
}

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_refresh_area
| 
|       Purpose: Do routine which is called when
|                  master action button refresh_area is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: 
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_refresh_area(
     gui_info_struct *master_info)
{
	if (!current_area)
	   return;

	xvw_refresh(current_area);
}

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_clear_layout
| 
|       Purpose: Do routine which is called when
|                  master action button clear_layout is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_clear_layout(
     gui_info_struct *master_info)
{
	int	 i, num;
	xvobject *children;

	children = xvw_children(layout, NULL, &num);
	if (num == 0) return;

	if (!(kprompt(KSTANDARD,  "Yes", "No", 0,
		      "Are you SURE you want to clear the xprism workspace?")))
		return;

	for (i = 0; i < num; i++)
	   xvw_destroy(children[i]);

	current_area = NULL; kfree(children);
}

/*-----------------------------------------------------------
| 
|  Routine Name: xprism_layout_menu
| 
|       Purpose: Do routine which is called when
|                  master action button layout_menu is used
| 
|         Input: master_info - ptr to FormInfo struct for xprism
| 
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_layout_menu(
     gui_info_struct *master_info)
{
	xvw_activate_menu(layout);
}

/*-----------------------------------------------------------
|
|  Routine Name: xprism_layout_menu
|
|       Purpose: Do routine which is called when
|                  master action button layout_menu is used
|
|         Input: master_info - ptr to FormInfo struct for xprism
|
|        Output: None
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
static void move_indicator(
    xvobject indicator,
    kaddr    client_data,
    XEvent   *event,
    int      *dispatch)
{
        int      id, dcx, dcy;
        Coord    coord;

        /*
         * event structure holds the (x,y) position of mouse in device coords.
         */
        dcx = event->xbutton.x;
        dcy = event->xbutton.y;

        /*
         * convert device coordinates of screen into the
         * world coordinates that are used by the indicator
         */
        id = (int) (xvw_widget(indicator));
        X2D_convert_point_dc_to_wc(id, (Real) dcx, (Real) dcy, &coord);

        xvw_set_attributes(indicator,
                XVW_INDICATOR_XPOS_VALUE, coord.x,
                XVW_INDICATOR_YPOS_VALUE, coord.y,
                NULL);

}
