 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane options
   >>>> 
   >>>>  Private: 
   >>>> 	options_area_list
   >>>> 	options_plot_list
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

static void activate_menu PROTO((xvclass, int *));
static void delete_item   PROTO((xvclass, int *));

/*-----------------------------------------------------------
| 
|  Routine Name: options_area_list
| 
|       Purpose: Do routine which is called when
|                  displaylist selection area_list is used
| 
|         Input: options_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mar 25, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void options_area_list(
     Options_options *options_info)
{
	xvobject *children;
	int	 num, indx = options_info->area_list - 1;

	if ((children = xvw_children(layout, AreaWidgetClass, &num)) != NULL)
	{
	   if (indx < num)
	   {
	      xvw_set_attribute(layout, XVW_LAYOUT_SELECTED_CHILD,
			children[indx]);
	      change_area(layout, NULL, &children[indx]);
	   }
	   kfree(children);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: options_plot_list
|
|       Purpose: Do routine which is called when
|                  displaylist selection plot_list is used
|
|         Input: options_info - ptr to PaneInfo struct for options pane
|
|        Output: None
|    Written By:
|          Date: Apr 11, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void options_plot_list(
     Options_options *options_info)
{
	if (options_info->plot_list == 1)
	    xvf_set_attribute(options_info->delete_plot_struct, 
			      XVF_ACTIVATE, FALSE);
	else xvf_set_attribute(options_info->delete_plot_struct, 
			       XVF_ACTIVATE, TRUE);
}

/*-----------------------------------------------------------
| 
|  Routine Name: options_open_area
| 
|       Purpose: Do routine which is called when
|                  pane action button open_area is used
| 
|         Input: options_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mar 25, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void options_open_area(
     Options_options *options_info)
{
	xvobject *children;
	int	 num, indx = options_info->area_list;

	if (indx == -1)
	   return;

	if ((children = xvw_children(layout, AreaWidgetClass, &num)) != NULL)
	{
	   if (indx <  num)
	      xvw_activate_menu(children[indx]);

	   kfree(children);
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: options_open_plot
| 
|       Purpose: Do routine which is called when
|                  pane action button open_plot is used
| 
|         Input: options_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 30, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void options_open_plot(
     Options_options *options_info)
{
	int indx;

	/* no item selected from list */
	if (options_info->plot_list == 0) return;

        indx = options_info->plot_list - 1;
        activate_menu(Axis2DGadgetClass, &indx);
        activate_menu(Plot2DGadgetClass, &indx);
        activate_menu(Plot3DGadgetClass, &indx);
}

/*-----------------------------------------------------------
| 
|  Routine Name: options_delete_plot
| 
|       Purpose: Do routine which is called when
|                  pane action button delete_plot is used
| 
|         Input: options_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 10, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void options_delete_plot(
     Options_options *options_info)
{
        int      indx;

        indx = options_info->plot_list - 1;
        if (indx == -1) return;

        if (options_info->plot_list != 0)
	{
            delete_item(Axis2DGadgetClass, &indx); 
            delete_item(Plot2DGadgetClass, &indx);
            delete_item(Plot3DGadgetClass, &indx);
	}
}

/*-----------------------------------------------------------
| 
|  Routine Name: options_delete_area
| 
|       Purpose: Do routine which is called when
|                  pane action button delete_area is used
| 
|         Input: options_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 10, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void options_delete_area(
     Options_options *options_info)
{
	xprism_remove_area(NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: activate_menu
|
|       Purpose: Activates menuform for the axis or plot by
|		 maintaining a dynamic list of objects that
|		 could potentially have menuforms activated.
|                To activate the menuform of one object in the plot 
|		 list, this routine should be called once for each class 
|		 of objects that can appear in the plot list. Suppose the 
|		 plot list can consist of 3 classes of objects, as in this 
|		 example:
|
|		 0 Axis
|		 1 Plot2D 1
|		 2 Plot2D 2
|		 3 Plot3D 1
|		 4 Plot3D 2
|
|		 Suppose we want to activate the menu for Plot3D 1.
|		 calling this routine for Axis class decrements indx
|		 from 3 to 2.  Calling this routine then for Plot2D class
|		 decrements indx from 2 to 0.  Finally, calling this
|		 routine for the Plot3D class results in the menuform
|		 being activated for Plot3D class child 0, the Plot3D 1
|		 object that we are looking for.
|
|         Input: class - indicates object type:
|                        Axis2DGadgetClass, 
|                        Plot2DGadgetClass, or
|                        Plot3DGadgetClass,
|
|        Output: indx - the desired indx of the desired object,
|			from the *remaining* objects to be checked.
|		        indx is decremented as each class of objects
|		        is removed from the list.
|    Written By: Mark Young & Danielle Argiro
|          Date: Apr 10, 1995
| Modifications:
|
------------------------------------------------------------*/

static void activate_menu(
    xvclass class,
    int     *indx)
{
        int      num;
        xvobject *children = NULL;

	if (*indx < 0) return;

        children = xvw_children(current_area, class, &num);
        if ((children != NULL) && (num != 0))
        {
	    if (*indx < num)
	    {
                xvw_activate_menu(children[*indx]);
	        if (class == Plot2DGadgetClass || class == Plot3DGadgetClass)
	            current_plot = children[*indx];
	    }
	    *indx = *indx - num;
        }
        kfree(children);
}

/*-----------------------------------------------------------
|
|  Routine Name: delete_item
|
|       Purpose: Deletes an axis or plot by maintaining a dynamic 
|                list of objects that could potentially be deleted.
|		 To delete one object from the plot list, this routine 
|		 should be called once for each class of objects that
|		 can appear in the plot list. Suppose the plot list 
|		 can consist of 3 classes of objects, as in this example:
|
|                0 Axis
|                1 Plot2D 1
|                2 Plot2D 2
|                3 Plot3D 1
|                4 Plot3D 2
|
|                Suppose we want to delete Plot3D 1.  Calling this routine 
|		 for Axis class decrements indx from 3 to 2.  Calling this 
|		 routine then for Plot2D class decrements indx from 2 to 0.  
|		 Finally, calling this routine for the Plot3D class results 
|		 in the menuform being activated for child 0, the Plot3D 1 
|		 object.
|
|         Input: class - indicates object type:
|                        Axis2DGadgetClass,
|                        Plot2DGadgetClass, or
|                        Plot3DGadgetClass,
|
|        Output: indx - the desired indx of the desired object,
|                       from the *remaining* objects to be checked.
|                       indx is decremented as each class of objects
|                       is removed from the list.
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Apr 10, 1995
| Modifications:
|
------------------------------------------------------------*/

static void delete_item(
    xvclass class,
    int     *indx)
{
        int      num;
        xvobject *children;

        children = xvw_children(current_area, class, &num);
        if (children != NULL)
        {
           if (*indx < num)
           {
              xvw_destroy(children[*indx]);
              kfree(children);
              return;
           }
           *indx = *indx - num;
           kfree(children);
        }
}
