 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for spectrum
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _spectrum_h_
#define _spectrum_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/*
 *  ID for expression parser
 */
#define SPC_ID 1

/*
 * red band, green band, blue band
 */
#define SPC_RED   1
#define SPC_BLUE  2
#define SPC_GREEN 3

/*
 *  changing column displayed as X or Y in plot
 */
#define SPC_X   1
#define SPC_Y   2
#define SPC_Z   3

/*
 * contents of map data
 */
#define SPC_MEANVECTORS   0
#define SPC_COUNT        (1L << 0)
#define SPC_CLASS        (1L << 1)
#define SPC_COVAR_MATRIX (1L << 2)
#define SPC_COVAR_DIAG   (1L << 3)

/*
 * number of colors used by scatter plot
 */
#define SPC_PLOTCOLORNUM 5

/*
 * operation performed with scatter plot
 */
#define SPC_ADD     1
#define SPC_DELETE  2

/*
 * plot options: non-proportional, proportional windowed, 
 *               or proportional non-windowed
 */
#define SPC_NONPROP          1
#define SPC_PROP_WINDOWED    2
#define SPC_PROP_NONWINDOWED 3

/*
 * different possibities wrt legend
 */
#define SPC_ALL       1
#define SPC_HIDDEN    2
#define SPC_DISPLAYED 3
#define SPC_EMPTY     4
#define SPC_NOTEMPTY  5

/*
 * different add/delete cluster methods
 */
#define SPC_PAINT   1
#define SPC_POLYGON 2

/*
 * update modes for spectral response curve
 */
#define SPC_CONTINOUS_SINGLE     0
#define SPC_BUTTONPRESS_MULTIPLE 1

/*
 * indicates how a legend entry was created: 
 *    directly, by the user, or
 *    from an entry in the legend file
 */
#define SPC_USER_CREATED 1
#define SPC_LGD_CREATED  2
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/xvroutine/spectrum/uis/spectrum.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  Filename of Object with Input Image (optional infile)
 */
char	*i_file;	/* Filename of Object with Input Image FILENAME */
int	 i_flag;	/* Filename of Object with Input Image FLAG */

/*
 *  Filename of Object with Input Legend (optional infile)
 */
char	*l_file;	/* Filename of Object with Input Legend FILENAME */
int	 l_flag;	/* Filename of Object with Input Legend FLAG */

/*
 *  input display environment file (optional infile)
 */
char	*t_file;	/* input display environment file FILENAME */
int	 t_flag;	/* input display environment file FLAG */

/*
 *  Read Only or Read Write Visual (Optional cycle)
 */
int	 visual_cycle;	/* Read Only or Read Write Visual CYCLE INDEX */
char	 *visual_label;	/* Read Only or Read Write Visual CYCLE LABEL */
int	 visual_flag;	/* Read Only or Read Write Visual FLAG */

/*
 *  method (Optional cycle)
 */
int	 method_cycle;	/* method CYCLE INDEX */
char	 *method_label;	/* method CYCLE LABEL */
int	 method_flag;	/* method FLAG */

} clui_info_struct;

/* -include_typedefs */
/*
 *  structure containing info about how the image is displayed
 */
typedef struct _ImageDisplayStruct {

    xvobject parent;             /* parent object of image display (-w line) */
    xvobject workspace;          /* object in/wh image is displayed          */
    xvobject colorbox;           /* colorbox showing current cluster         */
    xvobject position_label;     /* label showing image position             */
    xvobject cluster_label;      /* label showing cluster number             */
    xvobject panicon;            /* pan icon for image                       */
    xvobject utm_position;       /* labelstring for printing UTM coordinates */

    char *red_func;              /* current function for red band           */
    char *green_func;            /* current function for green band         */
    char *blue_func;             /* current function for blue band          */

    double *red_col;             /* current map column for red band         */
    double *green_col;           /* current map column for green band       */
    double *blue_col;            /* current map column for blue band        */

    double disp_min,  disp_max;  /* min & max of all 3 disp. cols           */
    double total_min, total_max; /* min & max of all columns                */
    double red_min,   red_max;   /* min & max of red column                 */
    double green_min, green_max; /* min & max of green column               */
    double blue_min,  blue_max;  /* min & max of blue column                */

    double pixel_dim_x;          /* pixel x dimension                       */
    double pixel_dim_y;          /* pixel y dimension                       */
    double utm_00_N;             /* UTM north coordinate                    */
    double utm_00_E;             /* UTM east coordinate                     */
    char  *utm_zone;             /* UTM zone                                */

    } ImageDisplayStruct;

/*
 *  structure holding legend information for a particular class
 */
typedef struct _LegendEntry  {

    int      class;       /* class id number                                */

    xvobject back;        /* backplane of legend entry object set           */
    xvobject colorbox;    /* box displaying the color for class             */
    xvobject RGBobj;      /* object displaying RGB values of color          */
    xvobject classnamebutton;  /* object displaying name assoc. w/ class    */

    xvobject contents_obj; /* label str on info subform w/ class + contents */

    char     *classname;       /* name identifying class                    */
    int      classname_token;  /* token assoc. w/ classname (fast searches) */

    int      redval;      /* value of RED component of class color          */
    int      greenval;    /* value of RED component of class color          */
    int      blueval;     /* value of RED component of class color          */

    int      clusternum;  /* number of clusters in class                    */
    int      *clusters;   /* cluster numbers in class                       */
 
    int      hidden;      /* TRUE if assoc. color not displayed             */

    int      orig_type;   /* SPC_USER_CREATED or SPC_LGD_CREATED            */

    struct _LegendEntry *next;  /* pointer to next legend entry             */

    } LegendEntry;

/*
 *  structure for Spectral Curve feature
 */
typedef struct _SpectralCurveStruct {

    xvobject parent;          /* parent of spectral curve display (-w line)  */
    xvobject colorbox;        /* color box showing color assoc. w/ class     */
    xvobject label;           /* label showing cluster number                */
    xvobject area;            /* area xvobject                               */
    xvobject axis;            /* (whole) axis xvobject                       */
    xvobject xaxis;           /* X axis xvobject                             */
    xvobject yaxis;           /* Y axis xvobject                             */
    xvobject plot;            /* SINGLE plot of map col values (continuous)  */
    xvobject *plots;          /* MULTIPLE plots (button press)               */
    int     plotnum;          /* number of plots when multiplots are used    */

    } SpectralCurveStruct;

/*
 *  structure for Scatter Plot feature
 */
typedef struct _ScatterPlotStruct {

    xvobject parent;            /* parent of scatterplot display (-w line)   */
    xvobject axis;              /* (whole) axis xvobject                     */
    xvobject xaxis;             /* X axis xvobject                           */
    xvobject yaxis;             /* Y axis xvobject                           */
    xvobject area;              /* area xvobject                             */
    xvobject plot;              /* plot xvobject                             */
    xvobject position_label;    /* label showing plot position               */
    xvobject cluster_label;     /* label showing cluster number              */
    xvobject plot_marker;       /* marker showing current pointer position   */
    xvobject colorcell;         /* colorcell to change image cluster colors  */

    Coord    *plotdata;         /* X & Y data currently plotted              */

    int      *cluster_numbers;  /* plot index gives assoc. cluster number    */
    int      *plot_lookup;      /* cluster numbers give assoc. plot index    */

    int      draw_plot_zoombox; /* whether to draw zoombox                   */

    int      xcol, ycol;        /* map columns providing data for X, Y       */

    double   actual_zoomfactor; /* actual zoom factor of plot                */
    double   potential_zoomfactor;  /* potential zoom factor of plot         */
    double   plot_x_focus;      /* X coefficient of plot focus               */
    double   plot_y_focus;      /* Y coefficient of plot focus               */
    double   wcxmin, wcxmax;    /* WC xmin and  xmax                         */
    double   wcymin, wcymax;    /* WC ymin and  ymax                         */


    } ScatterPlotStruct;

/*
 *  structure for Cluster Statistics / Class Contents feature
 */
typedef struct _InfoStruct {

   /* these are all the xvobjects used to display stats for a part. cluster */

    xvobject clusternum_obj;    /* label str showing cluster number         */
    xvobject assignedclass_obj; /* label str showing assigned class         */
    xvobject count_obj;         /* label str showing count value            */
    xvobject variance_obj;      /* label str showing variance               */
    xvobject *mapcols_obj;      /* array of label str showing map col values*/

   /* these are all the xvobjects used to display clusters in each class    */

    xvobject contents_viewport; /* vp containing label strings for contents */

    } InfoStruct;

/*
 *  structure for Transformation Info
 */
typedef struct _TransformStruct {

    char *name;                 /* name of transformation                   */
    char *red_equation;         /* equation to display as red               */
    char *green_equation;       /* equation to display as green             */
    char *blue_equation;        /* equation to display as blue              */

    } TransformStruct;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
/*
 *  image kobject data
 */
extern kobject  spc_image;               /* image being displayed            */
extern int      spc_image_type;          /* data type of image coming in     */

/*
 *  general info about map columns
 */
extern double   **spc_maps;              /* map data representing codebook   */
extern unsigned long spc_map_contents;   /* map contents                     */

extern int     spc_map_colnum;           /* number of map columns = (rowsize)*/
extern int     spc_map_rowsize;          /* size of map rows    = # columns) */
extern int     spc_map_rownum;           /* number of map rows    = (colsize */
extern int     spc_map_colsize;          /* size of map columns   = #rows    */

extern int     spc_unique_values;        /* unique values in the map data    */

extern double ***spc_covar_matrix;       /* stores the covariance matrix     */
extern int       spc_covar_matrix_size;  /* size of the covariance matrix    */
extern int       spc_matrix_size;        /* # cols in the covariance matrix  */
extern double  **spc_covar_diag;         /* stores the covariance diagonal   */
extern int       spc_diag_size;          /* # cols in the covariance diagonal*/

extern int     *spc_classes; /* cluster as index, class it belongs to as elem */
extern int     *spc_count;   /* count (histogram) array                       */

extern int spc_max_colors;         /* max # colors that can be displayed      */

/*
 *  workspaces in which things are displayed
 */
extern xvobject legend_workspace; /* object in/wh legend is displayed         */
extern xvobject legend_pseudo;    /* pseudocolor bars on legend display       */
extern xvobject zoom_workspace;   /* object in/wh zoom is displayed           */


/*
 *  book-keeping for legend, classes
 */
extern LegendEntry  *spc_legend_list;    /* list of legend entries            */
extern LegendEntry **spc_legend_lookup;  /* fast lookup of legend entries     */
extern LegendEntry  *spc_current_class;  /* current legend entry              */

extern char  **spc_mapcol_names;         /* names assigned to map cols by user*/ 
extern int     spc_legend_classnum;      /* current number of classes         */ 
/*
 *  structure associated w/ spectral curve
 */
extern SpectralCurveStruct *spc_curve; /* pointer to curve info            */

/*
 *  structure associated w/ scatter plot
 */
extern ScatterPlotStruct *spc_scatter; /* pointer to scatterplot info      */

/*
 *  info associated with functions, columns being displayed, normalization
 */
extern ImageDisplayStruct *spc_display; /* pointer to image display info   */

/*
 *  structure associated w/ statistics/class contents info
 */
extern InfoStruct *spc_info; /* pointer to statistics/class info      */

/*
 *  structure associated with transformation definitions read in
 *  from the display environment ascii file
 */
extern TransformStruct **spc_trans_info;
extern int               spc_trans_num;

extern Pixel             white;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void spectrum_get_args PROTO((kform *));
void spectrum_usage_additions PROTO((void));
void spectrum_free_args PROTO((int, kaddr));

/* -include_routines */
/* change_mapcol.c */
void spc_change_map_col          PROTO((kform_struct *, kform_struct *, int));
int  spc_change_map_col_function PROTO((char *, int));
void spc_update_map_col          PROTO((int));

/* class.c */
int  spc_delete_or_empty   PROTO((int));
int  spc_hide_or_show      PROTO((int));
int  spc_catch_all         PROTO((void));
int  spc_transfer_classes  PROTO((void));
void spc_set_class_color   PROTO((LegendEntry *));
int  spc_empty_class       PROTO((LegendEntry *));

/* cluster.c */
void spc_add_or_delete_cluster     PROTO((int));
int  spc_add_cluster_to_class      PROTO((LegendEntry *, int));
int  spc_delete_cluster_from_class PROTO((LegendEntry *, int));
void spc_update_image_position     PROTO((xvobject, kaddr, XEvent *, int *));
void spc_set_pseudo_color          PROTO((LegendEntry *));
void spc_refresh_class_colors      PROTO((void));

/* create.c */
void spc_create_legend_display  PROTO((void));
void spc_create_entry_display   PROTO((int, LegendEntry *, xvobject));
void spc_create_zoom_display    PROTO((void));
void spc_create_curve_display   PROTO((void));
void spc_create_scatter_display PROTO((void));
void spc_create_contents_display    PROTO((void));
void spc_create_stats_display    PROTO((void));
void spc_update_spectral_curve  PROTO((xvobject, kaddr, XEvent *, int *));
xvobject spc_create_classcontents_label PROTO((LegendEntry *, xvobject));
xvobject spc_create_mapcolstats_label   PROTO((int, xvobject));
int      spc_destroy_mapcolstats_labels PROTO((void));



/* curve.c */
void spc_update_spectral_curve PROTO((xvobject, kaddr, XEvent *, int *));
void spc_update_spectral_curve_classnames PROTO((void));
void spc_find_spectral_min_max PROTO((double *, double *));

/* do_zoom.c */
void spc_set_zoommode          PROTO((kaddr));

/* environ_io.c */
int spc_read_environ_file      PROTO((char *));

/* init.c */
void  spc_initialize  PROTO((void));


/* input.c */
void  spc_input_new_image    PROTO((char *));
int   spc_set_image_and_maps PROTO((char *));

/* legend.c */
LegendEntry *spc_add_legend_node    PROTO((int, int, int, int, 
					   char *, int *, int, int));
LegendEntry *spc_add_legend_entry   PROTO((int, int, int, int, 
                                           char *, int *, int, int));
LegendEntry *spc_create_legend_node PROTO((int, int, int, int, 
                                           char *, int *, int, int, int));
void spc_delete_legend_node       PROTO((LegendEntry *));
void spc_delete_legend_entry      PROTO((LegendEntry *));
void spc_delete_entire_legend     PROTO((void));
void spc_paint_from_img           PROTO((xvobject, kaddr, XEvent *, int *));
void spc_polygon_from_img         PROTO((xvobject, kaddr, XEvent *, int *));
void spc_initialize_legend_list   PROTO((void));


/* lgd_io.c */
int  spc_read_legend_file         PROTO((char *));
int  spc_write_legend_file        PROTO((char *));
int *spc_construct_legend_info    PROTO((int, int *, int  *, int *, 
					 int  *, char **));
void spc_register_image_classes   PROTO((void));



/* lgd_util.c */
void set_legend_values        PROTO((LegendEntry *, int, char *, int, int *));
void spc_update_legend_color_cb  PROTO((xvobject, kaddr, kaddr));
void spc_update_classname_cb     PROTO((xvobject, kaddr, kaddr));
void spc_list_class_contents_cb  PROTO((xvobject, kaddr, kaddr));
void spc_colorbox_cb             PROTO((xvobject, kaddr, kaddr));
void spc_set_current_class       PROTO((LegendEntry *));
void spc_update_cluster_stats PROTO((xvobject, kaddr, XEvent *, int *));
void spc_update_all_classcontents_labels PROTO((void));
void spc_update_classcontents_label      PROTO((LegendEntry *));
char *spc_set_classcontents_label        PROTO((LegendEntry *));



/* mapcol.c */
double *spc_perform_map_col_function PROTO((int, char **, int));

/* plot.c */
void spc_init_plot_info        PROTO((void));
int  spc_set_plotdata          PROTO((void));
void spc_find_plotdata_min_max PROTO((Coord *, int, double *, double *,
                                      double *, double *));
void spc_change_plot_col       PROTO((kform_struct *, int));
void spc_paint_from_plot 
			       PROTO((xvobject, kaddr, XEvent *, int *));
int  spc_identify_plot_point   PROTO((int, int, int *, int *));
void spc_update_plot_position  PROTO((xvobject, kaddr, XEvent *, int *));

void spc_apply_plot_function   PROTO((char *, int));

void spc_highlight_pointer_position PROTO((xvobject, kaddr, XEvent *, int *));

void spc_update_plot_position_labels PROTO((int));

/* output.c */
int spc_write_output_image         PROTO((char *));
int spc_write_output_grouped_image PROTO((char *));
int spc_write_output_maps          PROTO((char *));


/* setup.c */
int  spc_set_image_and_maps  PROTO((char *));

/* stats.c */
void mean_stddev PROTO((int, double *, int *, double *, double *));

/* string_utils.c */
char **spc_create_strings_mapcol_list   PROTO((void));
char **spc_create_strings_cluster_list  PROTO((int *, int));
char **spc_create_strings_category_list PROTO((char *, int, int *, char **, int));
char **spc_create_strings_variable_list PROTO((char *, int *));
char  *spc_create_string_function_def   PROTO((char *, char *, char **, int));
char  *spc_create_string_function_call  PROTO((int, int *, int, char *));
char  *spc_striptext                    PROTO((char *));
char  *spc_read_eqn_string_from_file        PROTO((char *));
LegendEntry *spc_find_legend_from_classname  PROTO((char *));




/* utilities.c */
int  spc_get_new_classname          PROTO((char **));
void spc_set_displayed_min_max      PROTO((void));
void spc_set_total_min_max          PROTO((void));
void spc_cleanup                    PROTO((void));
int  spc_get_unassigned_class_id    PROTO((void));
LegendEntry *spc_find_class_from_id PROTO((int));
void spc_update_utm_position        PROTO((xvobject, kaddr, XEvent *, int *));
void spc_update_GUI_from_mapcol_names PROTO((void));
void spc_install_add_or_delete_cluster_handler PROTO((int));
int  *spc_find_unique_values_from_polygon PROTO((kobject, int *));


/* SM routines */
double ** SM_get_matrix PROTO((int));
double dot_product      PROTO((double *, double *, int));
void   SM_add_vector    PROTO((int, int *, double *, double **, 
			       double *, double **));
int    SM_cfactor       PROTO((int, double **));
int    SM_copy_matrix   PROTO((int, double **, double **));
void   SM_csolve        PROTO((int, double **, double *));
void   SM_comb_stats    PROTO((int, int, int, int *, double *, double *, 
			       double *, double **, double **, double **));

int *classifyRemainingClusters PROTO((kobject, int, int, int, int, int *, 
				      double **, double ***, int *, int *));
/* -include_routines_end */

#endif
