 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Initializations Routines 
   >>>>
   >>>>  Private:
   >>>>         spc_initialize
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "spectrum.h"

/*-----------------------------------------------------------
|
|  Routine Name: spc_initialize
|
|       Purpose: Performs various initializations for spectrum
|
|         Input: None
|        Output: None
|       Returns: 
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications:
|
------------------------------------------------------------*/

void spc_initialize(void)
{
	Pixel bg;

	spc_image           = NULL;

	legend_workspace    = NULL;
	zoom_workspace	    = NULL;

	spc_legend_list     = NULL;
	spc_legend_lookup   = NULL;
	spc_current_class   = NULL;

	spc_curve           = NULL;
	spc_scatter         = NULL;
	spc_display         = NULL;
	spc_info            = NULL;

	spc_map_colnum      = 0;
	spc_map_rowsize     = 0;
	spc_map_rownum      = 0;
	spc_map_colsize     = 0;
	spc_legend_classnum = 0;

	spc_map_contents    = 0;

	spc_maps            = NULL;
	spc_unique_values   = 0;

	spc_covar_matrix    = NULL;
	spc_matrix_size     = 0;
	spc_covar_diag      = NULL;
	spc_diag_size       = 0;
	
	spc_classes         = NULL;
	spc_count           = NULL;

	spc_max_colors      = 256;
	spc_trans_info      = NULL;
	spc_trans_num       = 0;

	xvw_get_attribute(gui_info->image_workspace, XVW_BACKGROUND, &bg);
	white = bg;

}
