 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_spectrum
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_Files
   >>>> 	_xvf_get_files
   >>>> 	_xvf_get_Disp
   >>>> 	_xvf_get_disp
   >>>> 	_xvf_get_Curve
   >>>> 	_xvf_get_curve
   >>>> 	_xvf_get_Legend
   >>>> 	_xvf_get_legend
   >>>> 	_xvf_get_Zoom
   >>>> 	_xvf_get_zoom
   >>>> 	_xvf_get_Scatter
   >>>> 	_xvf_get_scatter
   >>>> 	_xvf_get_Stats
   >>>> 	_xvf_get_stats
   >>>> 	_xvf_get_Contents
   >>>> 	_xvf_get_contents
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_spectrum
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_spectrum(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->image_workspace_struct != NULL)
	{
	    selection = forminfo->image_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->image_workspace));
	    }

	}

	if (forminfo->add_class_struct != NULL)
	{
	    selection = forminfo->add_class_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->add_class));

	}

	if (forminfo->delete_class_struct != NULL)
	{
	    selection = forminfo->delete_class_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->delete_class));

	}

	if (forminfo->select_struct != NULL)
	{
	    selection = forminfo->select_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->select));

	}

	if (forminfo->cluster_operation_struct != NULL)
	{
	    char *value_string;
	    selection = forminfo->cluster_operation_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(forminfo->cluster_operation_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    forminfo->cluster_operation_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->cluster_operation_selected));
	    }

	}

	if (forminfo->add_cluster_manually_struct != NULL)
	{
	    selection = forminfo->add_cluster_manually_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->add_cluster_manually));

	}

	if (forminfo->delete_cluster_manually_struct != NULL)
	{
	    selection = forminfo->delete_cluster_manually_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->delete_cluster_manually));

	}

	if (forminfo->reassign_struct != NULL)
	{
	    selection = forminfo->reassign_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->reassign));

	}

	if (forminfo->autoclass_struct != NULL)
	{
	    selection = forminfo->autoclass_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->autoclass));

	}

	if (forminfo->Files_struct != NULL)
	{
	    subform = forminfo->Files_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Files_selected));
	    _xvf_get_Files(forminfo->Files);

	}
	if (forminfo->Disp_struct != NULL)
	{
	    subform = forminfo->Disp_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Disp_selected));
	    _xvf_get_Disp(forminfo->Disp);

	}
	if (forminfo->Curve_struct != NULL)
	{
	    subform = forminfo->Curve_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Curve_selected));
	    _xvf_get_Curve(forminfo->Curve);

	}
	if (forminfo->Legend_struct != NULL)
	{
	    subform = forminfo->Legend_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Legend_selected));
	    _xvf_get_Legend(forminfo->Legend);

	}
	if (forminfo->Zoom_struct != NULL)
	{
	    subform = forminfo->Zoom_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Zoom_selected));
	    _xvf_get_Zoom(forminfo->Zoom);

	}
	if (forminfo->Scatter_struct != NULL)
	{
	    subform = forminfo->Scatter_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Scatter_selected));
	    _xvf_get_Scatter(forminfo->Scatter);

	}
	if (forminfo->Stats_struct != NULL)
	{
	    subform = forminfo->Stats_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Stats_selected));
	    _xvf_get_Stats(forminfo->Stats);

	}
	if (forminfo->Contents_struct != NULL)
	{
	    subform = forminfo->Contents_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Contents_selected));
	    _xvf_get_Contents(forminfo->Contents);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Files
| 
|       Purpose: Extracts information from Files subform
| 
|         Input: subforminfo - pointer to spectrum_Files structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Files(
     spectrum_Files *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->files_struct != NULL)
	{
	    pane = subforminfo->files_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->files_selected));
	    _xvf_get_files(subforminfo->files);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_files
| 
|       Purpose: Extracts information from files pane
| 
|         Input: paneinfo - pointer to Files_files structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_files(
     Files_files *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Files->files' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->in_image_struct != NULL)
	{
	    selection = paneinfo->in_image_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->in_image != NULL) kfree(paneinfo->in_image);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->in_image));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->in_image_selected));
	    }
	}

	if (paneinfo->in_legend_struct != NULL)
	{
	    selection = paneinfo->in_legend_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->in_legend != NULL) kfree(paneinfo->in_legend);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->in_legend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->in_legend_selected));
	    }
	}

	if (paneinfo->in_environ_struct != NULL)
	{
	    selection = paneinfo->in_environ_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->in_environ != NULL) kfree(paneinfo->in_environ);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->in_environ));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->in_environ_selected));
	    }
	}

	if (paneinfo->out_image_struct != NULL)
	{
	    selection = paneinfo->out_image_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->out_image != NULL) kfree(paneinfo->out_image);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->out_image));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->out_image_selected));
	    }
	}

	if (paneinfo->out_legend_struct != NULL)
	{
	    selection = paneinfo->out_legend_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->out_legend != NULL) kfree(paneinfo->out_legend);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->out_legend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->out_legend_selected));
	    }
	}

	if (paneinfo->out_group_struct != NULL)
	{
	    selection = paneinfo->out_group_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->out_group != NULL) kfree(paneinfo->out_group);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->out_group));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->out_group_selected));
	    }
	}

	if (paneinfo->out_maps_struct != NULL)
	{
	    selection = paneinfo->out_maps_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->out_maps != NULL) kfree(paneinfo->out_maps);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->out_maps));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->out_maps_selected));
	    }
	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Disp
| 
|       Purpose: Extracts information from Disp subform
| 
|         Input: subforminfo - pointer to spectrum_Disp structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Disp(
     spectrum_Disp *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->disp_struct != NULL)
	{
	    pane = subforminfo->disp_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->disp_selected));
	    _xvf_get_disp(subforminfo->disp);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_disp
| 
|       Purpose: Extracts information from disp pane
| 
|         Input: paneinfo - pointer to Disp_disp structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_disp(
     Disp_disp *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Disp->disp' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->norm_type_struct != NULL)
	{
	    selection = paneinfo->norm_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->norm_type));
	    if (paneinfo->norm_type_label != NULL) kfree(paneinfo->norm_type_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->norm_type_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_type_selected));
	    }

	}

	if (paneinfo->norm_method_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->norm_method_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->norm_method_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->norm_method_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_method_selected));
	    }

	}

	if (paneinfo->change_mapcol_names_struct != NULL)
	{
	    selection = paneinfo->change_mapcol_names_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->change_mapcol_names));

	}

	if (paneinfo->list_mapcol_names_struct != NULL)
	{
	    selection = paneinfo->list_mapcol_names_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->list_mapcol_names));

	}

	if (paneinfo->t_struct != NULL)
	{
	    selection = paneinfo->t_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->t));

	}

	if (paneinfo->red_struct != NULL)
	{
	    selection = paneinfo->red_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red));

	}

	if (paneinfo->green_struct != NULL)
	{
	    selection = paneinfo->green_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green));

	}

	if (paneinfo->blue_struct != NULL)
	{
	    selection = paneinfo->blue_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue));

	}

	if (paneinfo->red_func_struct != NULL)
	{
	    selection = paneinfo->red_func_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->red_func != NULL) kfree(paneinfo->red_func);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->red_func));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_func_selected));
	    }

	}

	if (paneinfo->green_func_struct != NULL)
	{
	    selection = paneinfo->green_func_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->green_func != NULL) kfree(paneinfo->green_func);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->green_func));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_func_selected));
	    }

	}

	if (paneinfo->blue_func_struct != NULL)
	{
	    selection = paneinfo->blue_func_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->blue_func != NULL) kfree(paneinfo->blue_func);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->blue_func));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_func_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Curve
| 
|       Purpose: Extracts information from Curve subform
| 
|         Input: subforminfo - pointer to spectrum_Curve structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Curve(
     spectrum_Curve *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->curve_struct != NULL)
	{
	    pane = subforminfo->curve_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->curve_selected));
	    _xvf_get_curve(subforminfo->curve);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_curve
| 
|       Purpose: Extracts information from curve pane
| 
|         Input: paneinfo - pointer to Curve_curve structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_curve(
     Curve_curve *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Curve->curve' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->update_mode_struct != NULL)
	{
	   selection = paneinfo->update_mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->update_mode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->update_mode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->update_mode_selected));
	    }

	}

	if (paneinfo->clear_struct != NULL)
	{
	    selection = paneinfo->clear_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->clear));

	}

	if (paneinfo->curve_workspace_struct != NULL)
	{
	    selection = paneinfo->curve_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->curve_workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Legend
| 
|       Purpose: Extracts information from Legend subform
| 
|         Input: subforminfo - pointer to spectrum_Legend structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Legend(
     spectrum_Legend *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->legend_struct != NULL)
	{
	    pane = subforminfo->legend_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->legend_selected));
	    _xvf_get_legend(subforminfo->legend);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_legend
| 
|       Purpose: Extracts information from legend pane
| 
|         Input: paneinfo - pointer to Legend_legend structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_legend(
     Legend_legend *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Legend->legend' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->empty_struct != NULL)
	{
	    selection = paneinfo->empty_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->empty));

	}

	if (paneinfo->show_struct != NULL)
	{
	    selection = paneinfo->show_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->show));

	}

	if (paneinfo->catch_all_struct != NULL)
	{
	    selection = paneinfo->catch_all_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->catch_all));

	}

	if (paneinfo->hide_struct != NULL)
	{
	    selection = paneinfo->hide_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->hide));

	}

	if (paneinfo->transfer_struct != NULL)
	{
	    selection = paneinfo->transfer_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->transfer));

	}

	if (paneinfo->legend_workspace_struct != NULL)
	{
	    selection = paneinfo->legend_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->legend_workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Zoom
| 
|       Purpose: Extracts information from Zoom subform
| 
|         Input: subforminfo - pointer to spectrum_Zoom structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Zoom(
     spectrum_Zoom *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->zoom_struct != NULL)
	{
	    pane = subforminfo->zoom_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->zoom_selected));
	    _xvf_get_zoom(subforminfo->zoom);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_zoom
| 
|       Purpose: Extracts information from zoom pane
| 
|         Input: paneinfo - pointer to Zoom_zoom structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_zoom(
     Zoom_zoom *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Zoom->zoom' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->zoommode_struct != NULL)
	{
	   selection = paneinfo->zoommode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->zoommode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->zoommode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->zoommode_selected));
	    }

	}

	if (paneinfo->zoomfactor_struct != NULL)
	{
	    selection = paneinfo->zoomfactor_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->zoomfactor));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->zoomfactor_selected));
	    }

	}

	if (paneinfo->zoom_workspace_struct != NULL)
	{
	    selection = paneinfo->zoom_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->zoom_workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Scatter
| 
|       Purpose: Extracts information from Scatter subform
| 
|         Input: subforminfo - pointer to spectrum_Scatter structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Scatter(
     spectrum_Scatter *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->scatter_struct != NULL)
	{
	    pane = subforminfo->scatter_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->scatter_selected));
	    _xvf_get_scatter(subforminfo->scatter);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_scatter
| 
|       Purpose: Extracts information from scatter pane
| 
|         Input: paneinfo - pointer to Scatter_scatter structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_scatter(
     Scatter_scatter *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Scatter->scatter' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->x_column_struct != NULL)
	{
	    selection = paneinfo->x_column_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->x_column));

	}

	if (paneinfo->y_column_struct != NULL)
	{
	    selection = paneinfo->y_column_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->y_column));

	}

	if (paneinfo->x_func_struct != NULL)
	{
	    selection = paneinfo->x_func_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->x_func != NULL) kfree(paneinfo->x_func);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->x_func));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->x_func_selected));
	    }

	}

	if (paneinfo->y_func_struct != NULL)
	{
	    selection = paneinfo->y_func_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->y_func != NULL) kfree(paneinfo->y_func);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->y_func));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->y_func_selected));
	    }

	}

	if (paneinfo->set_struct != NULL)
	{
	    selection = paneinfo->set_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->set));

	}

	if (paneinfo->reset_struct != NULL)
	{
	    selection = paneinfo->reset_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->reset));

	}

	if (paneinfo->plot_workspace_struct != NULL)
	{
	    selection = paneinfo->plot_workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->plot_workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Stats
| 
|       Purpose: Extracts information from Stats subform
| 
|         Input: subforminfo - pointer to spectrum_Stats structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Stats(
     spectrum_Stats *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->stats_struct != NULL)
	{
	    pane = subforminfo->stats_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->stats_selected));
	    _xvf_get_stats(subforminfo->stats);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_stats
| 
|       Purpose: Extracts information from stats pane
| 
|         Input: paneinfo - pointer to Stats_stats structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_stats(
     Stats_stats *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Stats->stats' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->stats_wksp_struct != NULL)
	{
	    selection = paneinfo->stats_wksp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->stats_wksp));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Contents
| 
|       Purpose: Extracts information from Contents subform
| 
|         Input: subforminfo - pointer to spectrum_Contents structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Contents(
     spectrum_Contents *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->contents_struct != NULL)
	{
	    pane = subforminfo->contents_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->contents_selected));
	    _xvf_get_contents(subforminfo->contents);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_contents
| 
|       Purpose: Extracts information from contents pane
| 
|         Input: paneinfo - pointer to Contents_contents structure
| 
|        Output: none
|    Written By: conductor -name spectrum -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_contents(
     Contents_contents *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'spectrum->Contents->contents' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->contents_wksp_struct != NULL)
	{
	    selection = paneinfo->contents_wksp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->contents_wksp));
	    }

	}

}


