 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "putdata.h"
/*-----------------------------------------------------------
| 
|  Routine Name: putdata_get_args
| 
|       Purpose: Gets command line args for putdata
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname putdata
|          Date: Apr 10, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void putdata_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for putdata is out of sync with arguments specified in putdata's *.pane file; please rerun ghostwriter on putdata.";


	/*
	 * allocate the putdata structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "c",
			  &(clui_info->c_file),
			  &(clui_info->c_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "cmap",
			  &(clui_info->cmap_file),
			  &(clui_info->cmap_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "use_cmap",
			  &(clui_info->use_cmap_logic),
			  &(clui_info->use_cmap_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "x",
			  &(clui_info->x_int),
			  &(clui_info->x_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "width",
			  &(clui_info->width_int),
			  &(clui_info->width_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "y",
			  &(clui_info->y_int),
			  &(clui_info->y_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "height",
			  &(clui_info->height_int),
			  &(clui_info->height_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "update",
			  &(clui_info->update_float),
			  &(clui_info->update_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "image",
			  &(clui_info->image_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "pixel",
			  &(clui_info->pixel_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "imageicon",
			  &(clui_info->imageicon_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mapval",
			  &(clui_info->mapval_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "plot3d",
			  &(clui_info->plot3d_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "zoom",
			  &(clui_info->zoom_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "palette",
			  &(clui_info->palette_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "animate",
			  &(clui_info->animate_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "plot2d",
			  &(clui_info->plot2d_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "axis2d",
			  &(clui_info->axis2d_flag))))
	{
	    kerror(NULL, "putdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



