 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Functionality routines for getimage
   >>>>
   >>>>  Private:
   >>>>          capture_image()
   >>>>   Static:
   >>>>          find_named_object()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "getimage.h"

/*-----------------------------------------------------------
|
|  Routine Name: capture_image()
|
|       Purpose: captures an image
|
|         Input: 
|        Output: 
|       Returns: 
|    Written By: Mark Young & Danielle Argiro
|          Date: Apr 03, 1995
| Modifications:
|
------------------------------------------------------------*/
void capture_image(void)
{
	kobject  image;
	xvobject object = NULL;
	char     *format = NULL;
	int      rubberband = FALSE;
	char     *wname = NULL;


	/*
	 * open output object
	 */
	if ((image = kpds_open_object(clui_info->o_file, KOBJ_WRITE)) == NULL)
	{
	   kerror("getimage", "main", "unable to open output file",
		  clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}

	/*
	 * set file format
	 */
        if      (clui_info->ascii_flag)   format = KASCII;
        else if (clui_info->avs_flag)     format = KAVS;
        else if (clui_info->xbm_flag)     format = KXBM;
        else if (clui_info->pnm_flag)     format = KPNM;
        else if (clui_info->xvimage_flag) format = KXVIMAGE;
        else if (clui_info->eps_flag)     format = KEPS;
        else if (clui_info->xwd_flag)     format = KXWD;
        else if (clui_info->raw_flag)     format = KRAW;
        else if (clui_info->xpm_flag)     format = KXPM;
        else if (clui_info->rast_flag)    format = KRASTER;
        else format = KVIFF;
	if (!kpds_set_attribute(image, KPDS_FORMAT, format))
        {
           kerror("kformats", "main",
                  "Unable to set format (%s) on destination object", format);
           kfree(format);
           kexit(KEXIT_FAILURE);
        }

	/*
	 * if object is NULL, need them to click on the window to save.
	 */
	if (clui_info->win_flag)
	{
           /*
            * Get the entire window rather than a portion or subimage of one.
            */
	   kfprintf(kstderr,
		    "\nPlease click on the window to be captured.\n\n");
	}

	/*
	 *  Get the object depending on whether they specified the name of
	 *  window or the entire screen.  This will be passed to xvw_getimage,
	 *  which will do the actual work of capturing the window's image.
	 */
	if (clui_info->screen_flag == TRUE)
	   object = xvw_getobject(NULL, xvw_rootwindow(NULL), NULL);
	else
	{
	   if (clui_info->wname_flag) wname = clui_info->wname_string;
	   object = xvw_getobject(NULL, NONE, wname);
	}

	/*
	 *  rubberbanding a portion of the screen or the specified window
	 */
	if (!clui_info->all_flag)
	{
           /*
            * Get a portion or subimage of the window/screen rather than
            * entire one.
            */
           kfprintf(kstderr,"\nPlease rubberband the portion of the screen \nto be captured as a Khoros 2.0 VIFF file.\n\n");
	   rubberband = TRUE;
	}

	/*
	 *  Now that we have opened the output data object, call xvw_getimage
	 *  to do the actual work of getting the screen dump.  We pass in
	 *  object for the xvobject (the first parameter), since this will
	 *  be the object in which we will be getting the image for.
	 */
	if (!xvw_getimage(object, rubberband, clui_info->decor_flag, image))
	{
	   kpds_close_object(image);
	   kunlink(clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}
	kpds_close_object(image);
}
