 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_form
   >>>> 	_xvf_free_form
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_form_warning
   >>>> 	_xvf_init_form_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "extractor.h"

static void _xvf_init_form_warning PROTO((char *));
static void _xvf_init_form_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_form_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_form(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;

	master = form->master;
	/*
	 * initializing 'form' Form Info structure
	 */

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "form.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_form_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "form.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_form_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "form.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_form_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->wksp_struct =
	    kvf_create_struct_from_selname(master->sel_list, "form.wksp");
	if (forminfo->wksp_struct == NULL)
	    _xvf_init_form_warning("workspace 'wksp' on master form");
	else
	{
	    kvf_get_attribute(forminfo->wksp_struct, KVF_WORKSPACE,
	                    &(forminfo->wksp));

	}
	forminfo->blank1_struct =
	    kvf_create_struct_from_selname(master->sel_list, "form.blank1");
	if (forminfo->blank1_struct == NULL)
	    _xvf_init_form_warning("blank selection 'blank1' on master form");
	forminfo->subform_struct =
	    kvf_create_struct_from_subformname(form, "form.subform");
	if (forminfo->subform_struct == NULL)
	{
	    _xvf_init_form_error("subform 'subform' on form 'form'", 
			    "form_subform");
	    return(FALSE);
	}

	/*
	 * initializing 'form->subform' Subform Info structure
	 */

	forminfo->subform = (form_subform *)
				kcalloc(1, sizeof(form_subform));
	subform = forminfo->subform_struct->Subformptr;

	/*
	 * initializing 'form->subform->pane' Pane Info structure
	 */

	forminfo->subform->pane = (subform_pane *)
				kcalloc(1, sizeof(subform_pane));
	forminfo->subform->pane_struct =
	    kvf_create_struct_from_panename(subform, "form.subform.pane");
	if (forminfo->subform->pane_struct == NULL)
	{
	    _xvf_init_form_error("pane 'pane' on subform 'subform'", "subform_pane");
	    return(FALSE);
	}
	pane = forminfo->subform->pane_struct->Controlptr;
	forminfo->subform->pane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.help");
	if (forminfo->subform->pane->help_struct == NULL)
		    _xvf_init_form_warning("unknown selection 'help' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.quit");
	if (forminfo->subform->pane->quit_struct == NULL)
		    _xvf_init_form_warning("quit button 'quit' on pane 'pane' of subform 'subform'");
	forminfo->subform->pane->quit = FALSE;

	forminfo->subform->pane->i_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.i");
	if (forminfo->subform->pane->i_struct != NULL)
	{
	    selection = forminfo->subform->pane->i_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->i_struct, KVF_FILE_DEF,
	                    &(forminfo->subform->pane->i));
	}
	else
	    _xvf_init_form_warning("input selection 'i' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->i_selected = FALSE;

	forminfo->subform->pane->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.o");
	if (forminfo->subform->pane->o_struct != NULL)
	{
	    selection = forminfo->subform->pane->o_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->o_struct, KVF_FILE_DEF,
	                    &(forminfo->subform->pane->o));
	}
	else
	    _xvf_init_form_warning("output selection 'o' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->o_selected = FALSE;

	forminfo->subform->pane->policy_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.policy");
	if (forminfo->subform->pane->policy_struct != NULL)
	{
	    selection = forminfo->subform->pane->policy_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->policy_struct, KVF_LIST_VAL,
	                    &(forminfo->subform->pane->policy));
	    kvf_get_attribute(forminfo->subform->pane->policy_struct, KVF_LIST_LABEL,
	                    &(forminfo->subform->pane->policy_label));
	}
	else
	    _xvf_init_form_warning("list selection 'policy' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->policy_selected = FALSE;

	forminfo->subform->pane->disp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.disp");
	if (forminfo->subform->pane->disp_struct != NULL)
	{
	    selection = forminfo->subform->pane->disp_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->disp_struct, KVF_LOGIC_DEF,
	                    &(forminfo->subform->pane->disp));
	    kvf_get_attribute(forminfo->subform->pane->disp_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->subform->pane->disp_label));
	}
	else
	    _xvf_init_form_warning("logical selection 'disp' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->disp_selected = FALSE;

	forminfo->subform->pane->mult_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.mult");
	if (forminfo->subform->pane->mult_struct != NULL)
	{
	    selection = forminfo->subform->pane->mult_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->mult_struct, KVF_LOGIC_DEF,
	                    &(forminfo->subform->pane->mult));
	    kvf_get_attribute(forminfo->subform->pane->mult_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->subform->pane->mult_label));
	}
	else
	    _xvf_init_form_warning("logical selection 'mult' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->mult_selected = FALSE;

	forminfo->subform->pane->pres_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.pres");
	if (forminfo->subform->pane->pres_struct != NULL)
	{
	    selection = forminfo->subform->pane->pres_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->pres_struct, KVF_LIST_VAL,
	                    &(forminfo->subform->pane->pres));
	    kvf_get_attribute(forminfo->subform->pane->pres_struct, KVF_LIST_LABEL,
	                    &(forminfo->subform->pane->pres_label));
	}
	else
	    _xvf_init_form_warning("list selection 'pres' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->pres_selected = FALSE;

	forminfo->subform->pane->shape_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.shape");
	if (forminfo->subform->pane->shape_struct != NULL)
	{
	    selection = forminfo->subform->pane->shape_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->shape_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->subform->pane->shape_num));
	    forminfo->subform->pane->shape_val = 1;
	}
	else
	    _xvf_init_form_warning("toggle selection 'shape' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->shape_selected = FALSE;

	forminfo->subform->pane->mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.mode");
	if (forminfo->subform->pane->mode_struct != NULL)
	{
	    selection = forminfo->subform->pane->mode_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->mode_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->subform->pane->mode_num));
	    forminfo->subform->pane->mode_val = 1;
	}
	else
	    _xvf_init_form_warning("toggle selection 'mode' on pane 'pane' of subform 'subform'");

	forminfo->subform->pane->mode_selected = FALSE;

	forminfo->subform->pane->line_x1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.line_x1");
	if (forminfo->subform->pane->line_x1_struct != NULL)
	{
	    selection = forminfo->subform->pane->line_x1_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->line_x1_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->line_x1));
	}
	else
	    _xvf_init_form_warning("integer selection 'line_x1' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->circle_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.circle_x");
	if (forminfo->subform->pane->circle_x_struct != NULL)
	{
	    selection = forminfo->subform->pane->circle_x_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->circle_x_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->circle_x));
	}
	else
	    _xvf_init_form_warning("integer selection 'circle_x' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->ellipse_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.ellipse_x");
	if (forminfo->subform->pane->ellipse_x_struct != NULL)
	{
	    selection = forminfo->subform->pane->ellipse_x_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->ellipse_x_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->ellipse_x));
	}
	else
	    _xvf_init_form_warning("integer selection 'ellipse_x' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->rect_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.rect_x");
	if (forminfo->subform->pane->rect_x_struct != NULL)
	{
	    selection = forminfo->subform->pane->rect_x_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->rect_x_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->rect_x));
	}
	else
	    _xvf_init_form_warning("integer selection 'rect_x' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->line_x2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.line_x2");
	if (forminfo->subform->pane->line_x2_struct != NULL)
	{
	    selection = forminfo->subform->pane->line_x2_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->line_x2_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->line_x2));
	}
	else
	    _xvf_init_form_warning("integer selection 'line_x2' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->circle_radius_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.circle_radius");
	if (forminfo->subform->pane->circle_radius_struct != NULL)
	{
	    selection = forminfo->subform->pane->circle_radius_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->circle_radius_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->circle_radius));
	}
	else
	    _xvf_init_form_warning("integer selection 'circle_radius' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->ellipse_a_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.ellipse_a");
	if (forminfo->subform->pane->ellipse_a_struct != NULL)
	{
	    selection = forminfo->subform->pane->ellipse_a_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->ellipse_a_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->ellipse_a));
	}
	else
	    _xvf_init_form_warning("integer selection 'ellipse_a' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->rect_width_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.rect_width");
	if (forminfo->subform->pane->rect_width_struct != NULL)
	{
	    selection = forminfo->subform->pane->rect_width_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->rect_width_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->rect_width));
	}
	else
	    _xvf_init_form_warning("integer selection 'rect_width' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->extract_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.extract");
	if (forminfo->subform->pane->extract_struct == NULL)
	    _xvf_init_form_warning("pane action button 'extract' on pane 'pane' of subform 'subform'");
	forminfo->subform->pane->extract = FALSE;
	selection = forminfo->subform->pane->extract_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->subform->pane->line_y1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.line_y1");
	if (forminfo->subform->pane->line_y1_struct != NULL)
	{
	    selection = forminfo->subform->pane->line_y1_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->line_y1_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->line_y1));
	}
	else
	    _xvf_init_form_warning("integer selection 'line_y1' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->circle_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.circle_y");
	if (forminfo->subform->pane->circle_y_struct != NULL)
	{
	    selection = forminfo->subform->pane->circle_y_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->circle_y_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->circle_y));
	}
	else
	    _xvf_init_form_warning("integer selection 'circle_y' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->ellipse_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.ellipse_y");
	if (forminfo->subform->pane->ellipse_y_struct != NULL)
	{
	    selection = forminfo->subform->pane->ellipse_y_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->ellipse_y_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->ellipse_y));
	}
	else
	    _xvf_init_form_warning("integer selection 'ellipse_y' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->rect_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.rect_y");
	if (forminfo->subform->pane->rect_y_struct != NULL)
	{
	    selection = forminfo->subform->pane->rect_y_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->rect_y_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->rect_y));
	}
	else
	    _xvf_init_form_warning("integer selection 'rect_y' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->line_y2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.line_y2");
	if (forminfo->subform->pane->line_y2_struct != NULL)
	{
	    selection = forminfo->subform->pane->line_y2_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->line_y2_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->line_y2));
	}
	else
	    _xvf_init_form_warning("integer selection 'line_y2' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->ellipse_b_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.ellipse_b");
	if (forminfo->subform->pane->ellipse_b_struct != NULL)
	{
	    selection = forminfo->subform->pane->ellipse_b_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->ellipse_b_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->ellipse_b));
	}
	else
	    _xvf_init_form_warning("integer selection 'ellipse_b' on pane 'pane' of subform 'subform'");


	forminfo->subform->pane->rect_height_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.subform.pane.rect_height");
	if (forminfo->subform->pane->rect_height_struct != NULL)
	{
	    selection = forminfo->subform->pane->rect_height_struct->Selptr;
	    kvf_get_attribute(forminfo->subform->pane->rect_height_struct, KVF_INT_DEF,
	                    &(forminfo->subform->pane->rect_height));
	}
	else
	    _xvf_init_form_warning("integer selection 'rect_height' on pane 'pane' of subform 'subform'");


	forminfo->form_struct =
	    kvf_create_struct_from_mastername(form, "form");
	if (forminfo->form_struct == NULL)
	{
	    _xvf_init_form_error("form 'form'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_form_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_form_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_form
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_form_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_form(
    gui_info_struct *forminfo)
{
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->wksp_struct != NULL)
	    kfree(forminfo->wksp_struct);
	if (forminfo->blank1_struct != NULL)
	    kfree(forminfo->blank1_struct);
	if (forminfo->subform->pane->help_struct != NULL)
	    kfree(forminfo->subform->pane->help_struct);
	if (forminfo->subform->pane->quit_struct != NULL)
	    kfree(forminfo->subform->pane->quit_struct);
	kfree(forminfo->subform->pane->i);
	if (forminfo->subform->pane->i_struct != NULL)
	    kfree(forminfo->subform->pane->i_struct);
	kfree(forminfo->subform->pane->o);
	if (forminfo->subform->pane->o_struct != NULL)
	    kfree(forminfo->subform->pane->o_struct);
	if (forminfo->subform->pane->policy_struct != NULL)
	    kfree(forminfo->subform->pane->policy_struct);
	kfree(forminfo->subform->pane->policy_label);
	if (forminfo->subform->pane->disp_struct != NULL)
	    kfree(forminfo->subform->pane->disp_struct);
	kfree(forminfo->subform->pane->disp_label);
	if (forminfo->subform->pane->mult_struct != NULL)
	    kfree(forminfo->subform->pane->mult_struct);
	kfree(forminfo->subform->pane->mult_label);
	if (forminfo->subform->pane->pres_struct != NULL)
	    kfree(forminfo->subform->pane->pres_struct);
	kfree(forminfo->subform->pane->pres_label);
	if (forminfo->subform->pane->shape_struct != NULL)
	    kfree(forminfo->subform->pane->shape_struct);
	if (forminfo->subform->pane->mode_struct != NULL)
	    kfree(forminfo->subform->pane->mode_struct);
	if (forminfo->subform->pane->line_x1_struct != NULL)
	     kfree(forminfo->subform->pane->line_x1_struct);
	if (forminfo->subform->pane->circle_x_struct != NULL)
	     kfree(forminfo->subform->pane->circle_x_struct);
	if (forminfo->subform->pane->ellipse_x_struct != NULL)
	     kfree(forminfo->subform->pane->ellipse_x_struct);
	if (forminfo->subform->pane->rect_x_struct != NULL)
	     kfree(forminfo->subform->pane->rect_x_struct);
	if (forminfo->subform->pane->line_x2_struct != NULL)
	     kfree(forminfo->subform->pane->line_x2_struct);
	if (forminfo->subform->pane->circle_radius_struct != NULL)
	     kfree(forminfo->subform->pane->circle_radius_struct);
	if (forminfo->subform->pane->ellipse_a_struct != NULL)
	     kfree(forminfo->subform->pane->ellipse_a_struct);
	if (forminfo->subform->pane->rect_width_struct != NULL)
	     kfree(forminfo->subform->pane->rect_width_struct);
	if (forminfo->subform->pane->extract_struct != NULL)
	    kfree(forminfo->subform->pane->extract_struct);
	if (forminfo->subform->pane->line_y1_struct != NULL)
	     kfree(forminfo->subform->pane->line_y1_struct);
	if (forminfo->subform->pane->circle_y_struct != NULL)
	     kfree(forminfo->subform->pane->circle_y_struct);
	if (forminfo->subform->pane->ellipse_y_struct != NULL)
	     kfree(forminfo->subform->pane->ellipse_y_struct);
	if (forminfo->subform->pane->rect_y_struct != NULL)
	     kfree(forminfo->subform->pane->rect_y_struct);
	if (forminfo->subform->pane->line_y2_struct != NULL)
	     kfree(forminfo->subform->pane->line_y2_struct);
	if (forminfo->subform->pane->ellipse_b_struct != NULL)
	     kfree(forminfo->subform->pane->ellipse_b_struct);
	if (forminfo->subform->pane->rect_height_struct != NULL)
	     kfree(forminfo->subform->pane->rect_height_struct);
	kfree(forminfo->subform->pane);
	if (forminfo->subform->pane_struct != NULL)
	    kfree(forminfo->subform->pane_struct);


	if (forminfo->subform_struct != NULL)
	    kfree(forminfo->subform_struct);
	kfree(forminfo->subform);
	kfree(forminfo);
}
