 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'extractor'
   >>>> 
   >>>>  Private: 
   >>>> 	run_form
   >>>> 	run_subform
   >>>> 	run_pane
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "extractor.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_form
| 
|       Purpose: Main GUI Driver for extractor
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_form(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_form(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_form(master_info);
	    return;
	}

	/*
	 * action came from the 'subform' subform
	 */
	if (master_info->subform_selected)
	    run_subform(master_info->subform);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_subform
| 
|       Purpose: GUI Driver for subform 'subform'
| 
|         Input: form      - pointer to the form tree
|                subform_info - pointer to form_subform struct
| 
|        Output: None
|    Written By: conductor -program_name extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_subform(
     form_subform *subform_info)
{

	/*
	 * action came from the 'pane' pane
	 */
	if (subform_info->pane_selected)
	    run_pane(subform_info->pane);


}   /* end run_subform */



/*-----------------------------------------------------------
| 
|  Routine Name: run_pane
| 
|       Purpose: GUI Driver for pane 'pane'
| 
|         Input: form - pointer to the form tree
|                pane_info - pointer to subform_pane struct
| 
|        Output: None
|    Written By: conductor -program_name extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_pane(
     subform_pane *pane_info)

{

	/*
	 * user selected 'live' input file selection 'i'
	 */
	if (pane_info->i_selected)
	{
	    pane_i(pane_info);
	    pane_info->i_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'o'
	 */
	else if (pane_info->o_selected)
	{
	    pane_o(pane_info);
	    pane_info->o_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'policy'
	 */
	else if (pane_info->policy_selected)
	{
	    pane_policy(pane_info);
	    pane_info->policy_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'disp'
	 */
	else if (pane_info->disp_selected)
	{
	    pane_disp(pane_info);
	    pane_info->disp_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'mult'
	 */
	else if (pane_info->mult_selected)
	{
	    pane_mult(pane_info);
	    pane_info->mult_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'pres'
	 */
	else if (pane_info->pres_selected)
	{
	    pane_pres(pane_info);
	    pane_info->pres_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'shape'
	 */
	else if (pane_info->shape_selected)
	{
	    pane_shape(pane_info);
	    pane_info->shape_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'mode'
	 */
	else if (pane_info->mode_selected)
	{
	    pane_mode(pane_info);
	    pane_info->mode_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'extract'
	 */
	else if (pane_info->extract)
	{
	    pane_extract(pane_info);
	    pane_info->extract = FALSE;
	}


}


