 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane pane
   >>>> 
   >>>>  Private: 
   >>>> 	pane_i
   >>>> 	pane_o
   >>>> 	pane_policy
   >>>> 	pane_shape
   >>>> 	pane_disp
   >>>> 	pane_mult
   >>>> 	pane_pres
   >>>> 	pane_mode
   >>>> 	pane_extract
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "extractor.h"

xvobject image;
xvobject position;
xvobject panicon;

xvobject disp_roi;
xvobject disp_area;
xvobject disp_axis2d;
xvobject disp_plot2d;
xvobject disp_plot3d;
xvobject disp_image;

/*-----------------------------------------------------------
| 
|  Routine Name: pane_i
| 
|       Purpose: Do routine which is called when
|                  input selection i is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 19, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_i(
     subform_pane *pane_info)
{
	xvw_set_attribute(image,    XVW_IMAGE_IMAGEFILE,   pane_info->i);
	xvw_set_attribute(panicon,  XVW_IMAGE_IMAGEFILE,   pane_info->i);
	xvw_set_attribute(position, XVW_POSITION_FILENAME, pane_info->i);
}

/*-----------------------------------------------------------
|
|  Routine Name: pane_o
|
|       Purpose: Do routine which is called when
|                  output selection o is used
|
|         Input: pane_info - ptr to PaneInfo struct for pane pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 04, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void pane_o(
     subform_pane *pane_info)
{
	int dummy;
	get_roi(image, NULL, NULL, &dummy);
}


/*-----------------------------------------------------------
| 
|  Routine Name: pane_policy
| 
|       Purpose: Do routine which is called when
|                  list selection policy is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 19, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_policy(
     subform_pane *pane_info)
{
	if ((pane_info->policy == KIMAGE_ROI_OUTSIDE) &&
            (pane_info->pres == KIMAGE_ROI_SURFACE))
        {
            kerror(NULL, "roi_policy", "It doesn't make sense to set ROI policy to 'Outside Shape' when the ROI Presentation type is 'Surface'; resetting ROI policy to 'Inside Shape'");
            xvf_set_attribute(pane_info->policy_struct, XVF_LIST_VAL,
                              KIMAGE_ROI_INSIDE);
            pane_info->policy = KIMAGE_ROI_INSIDE;
            return;
        }
        else xvw_set_attribute(image, XVW_IMAGE_ROI_POLICY, pane_info->policy);
}

/*-----------------------------------------------------------
| 
|  Routine Name: pane_shape
| 
|       Purpose: Do routine which is called when
|                  toggle selection shape is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 19, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_shape(
     subform_pane *pane_info)
{
	xvw_set_attribute(image, XVW_IMAGE_ROI_SHAPE, pane_info->shape_val);

	adjust_gui_from_roi_shape();
}

/*-----------------------------------------------------------
| 
|  Routine Name: pane_disp
| 
|       Purpose: Do routine which is called when
|                  logical selection disp is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Dec 20, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_disp(
     subform_pane *pane_info)
{
	if (disp_roi == NULL)
	   return;

	/* 
	 * unmap/map toplevel according to if the user wants the toplevel
	 * displayed
	 */
	if (!pane_info->disp)
	    xvw_unmap(xvw_toplevel(disp_roi));
	else
	    xvw_map(xvw_toplevel(disp_roi));
}


/*-----------------------------------------------------------
| 
|  Routine Name: pane_mult
| 
|       Purpose: Do routine which is called when
|                  logical selection mult is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 04, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_mult(
     subform_pane *pane_info)
{
	if ((pane_info->pres != KIMAGE_ROI_IMAGE) && 
	    (pane_info->mult == TRUE))
	{
	    kerror(NULL, "pane_mult", "Cannot extract multiple images when ROI presentation type is not set to 'Image'");
	    xvf_set_attribute(pane_info->mult_struct, XVF_LOGIC_VAL, FALSE);
	    pane_info->mult = FALSE;
	}
	else xvw_set_attribute(image, XVW_IMAGE_ROI_MULTIPLE, pane_info->mult);
}


/*-----------------------------------------------------------
| 
|  Routine Name: pane_pres
| 
|       Purpose: Do routine which is called when
|                  list selection pres is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 05, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_pres(
     subform_pane *pane_info)
{
        /*
         * it doesn't make sense to display signal or surface
         * if extracting multiple images
         */
	if ((pane_info->pres != KIMAGE_ROI_IMAGE) &&
            (pane_info->mult == TRUE))
        {
            kerror(NULL, "pane_mult", "Cannot set ROI presentation type to 'Signal' or 'Surface' unless 'Extract Multiple ROIs' is set to 'FALSE'");
            xvf_set_attribute(pane_info->pres_struct, XVF_LIST_VAL, 
 			      KIMAGE_ROI_IMAGE);
            pane_info->pres = KIMAGE_ROI_IMAGE;
        }

        /*
         * doesn't make sense to display surface if extracting outside image
         */
        if ((pane_info->pres != KIMAGE_ROI_IMAGE) &&
            (pane_info->policy == KIMAGE_ROI_OUTSIDE))
        {
            kerror(NULL, "roi_pres", "Cannot set ROI presentation type to 'Signal' or 'Surface' unless 'ROI Policy' is set to 'Inside Shape' or 'Shape Outline'");
            xvf_set_attribute(pane_info->pres_struct, XVF_LIST_VAL,
                              KIMAGE_ROI_IMAGE);
            pane_info->pres = KIMAGE_ROI_IMAGE;
        }
	else xvw_set_attribute(image, XVW_IMAGE_ROI_PRESENTATION, pane_info->pres);
}


/*-----------------------------------------------------------
| 
|  Routine Name: pane_mode
| 
|       Purpose: Do routine which is called when
|                  toggle selection mode is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 06, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_mode(
     subform_pane *pane_info)
{
        adjust_gui_from_roi_mode();
}


/*-----------------------------------------------------------
| 
|  Routine Name: pane_extract
| 
|       Purpose: Do routine which is called when
|                  pane action button extract is used
| 
|         Input: pane_info - ptr to PaneInfo struct for pane pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 06, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void pane_extract(
     subform_pane *pane_info)
{
	int dummy;
	get_roi(image, NULL, NULL, &dummy);
}


