 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "editimage.h"
/*-----------------------------------------------------------
| 
|  Routine Name: editimage_get_args
| 
|       Purpose: Gets command line args for editimage
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname editimage
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void editimage_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for editimage is out of sync with arguments specified in editimage's *.pane file; please rerun ghostwriter on editimage.";


	/*
	 * allocate the editimage structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "c",
			  &(clui_info->c_file),
			  &(clui_info->c_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "cmap",
			  &(clui_info->cmap_file),
			  &(clui_info->cmap_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "use_cmap",
			  &(clui_info->use_cmap_logic),
			  &(clui_info->use_cmap_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "zoom",
			  &(clui_info->zoom_float),
			  &(clui_info->zoom_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "update",
			  &(clui_info->update_float),
			  &(clui_info->update_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "visual", KVF_LIST_LABEL,
			  &(clui_info->visual_label),
			  &(clui_info->visual_flag)) &&
	      kclui_get_value(pane, "visual", KVF_LIST_VAL,
			  &(clui_info->visual_cycle),
			  &(clui_info->visual_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "editimage_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



