 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'animate'
   >>>> 
   >>>>  Private: 
   >>>> 	run_animate
   >>>> 	run_File
   >>>> 	run_file
   >>>> 	run_options
   >>>> 	run_attributes
   >>>> 	run_display
   >>>> 	run_lists
   >>>> 	run_function
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_animate
| 
|       Purpose: Main GUI Driver for animate
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_animate(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_animate(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_animate(master_info);
	    return;
	}

	    /*
	     * user clicked on master action button selection 'reverse'
	     */
	    if (master_info->reverse)
	        animate_reverse(master_info);
	    /*
	     * user clicked on master action button selection 'previous'
	     */
	    else if (master_info->previous)
	        animate_previous(master_info);
	    /*
	     * user clicked on master action button selection 'stop'
	     */
	    else if (master_info->stop)
	        animate_stop(master_info);
	    /*
	     * user clicked on master action button selection 'next'
	     */
	    else if (master_info->next)
	        animate_next(master_info);
	    /*
	     * user clicked on master action button selection 'forward'
	     */
	    else if (master_info->forward)
	        animate_forward(master_info);
	/*
	 * action came from the 'File' subform
	 */
	if (master_info->File_selected)
	    run_File(master_info->File);
	/*
	 * action came from the 'options' subform
	 */
	if (master_info->options_selected)
	    run_options(master_info->options);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_File
| 
|       Purpose: GUI Driver for subform 'File'
| 
|         Input: form      - pointer to the form tree
|                File_info - pointer to animate_File struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_File(
     animate_File *File_info)
{

	/*
	 * action came from the 'file' pane
	 */
	if (File_info->file_selected)
	    run_file(File_info->file);


}   /* end run_File */



/*-----------------------------------------------------------
| 
|  Routine Name: run_file
| 
|       Purpose: GUI Driver for pane 'file'
| 
|         Input: form - pointer to the form tree
|                file_info - pointer to File_file struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_file(
     File_file *file_info)

{

	/*
	 * user selected 'live' input file selection 'i'
	 */
	if ((file_info->i_selected)  && (file_info->i_optsel))
	{
	    file_i(file_info);
	    file_info->i_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'b'
	 */
	else if ((file_info->b_selected)  && (file_info->b_optsel))
	{
	    file_b(file_info);
	    file_info->b_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'c'
	 */
	else if (file_info->c_selected)
	{
	    file_c(file_info);
	    file_info->c_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'cmap'
	 */
	else if (file_info->cmap_selected)
	{
	    file_cmap(file_info);
	    file_info->cmap_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'o'
	 */
	else if (file_info->o_selected)
	{
	    file_o(file_info);
	    file_info->o_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_options
| 
|       Purpose: GUI Driver for subform 'options'
| 
|         Input: form      - pointer to the form tree
|                options_info - pointer to animate_options struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_options(
     animate_options *options_info)
{

	/*
	 * action came from the 'attributes' pane
	 */
	if (options_info->attributes_selected)
	    run_attributes(options_info->attributes);

	/*
	 * action came from the 'display' pane
	 */
	else if (options_info->display_selected)
	    run_display(options_info->display);

	/*
	 * action came from the 'lists' pane
	 */
	else if (options_info->lists_selected)
	    run_lists(options_info->lists);

	/*
	 * action came from the 'function' pane
	 */
	else if (options_info->function_selected)
	    run_function(options_info->function);


}   /* end run_options */



/*-----------------------------------------------------------
| 
|  Routine Name: run_attributes
| 
|       Purpose: GUI Driver for pane 'attributes'
| 
|         Input: form - pointer to the form tree
|                attributes_info - pointer to options_attributes struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_attributes(
     options_attributes *attributes_info)

{

	/*
	 * user selected 'live' flag selection 'elements'
	 */
	if (attributes_info->elements_selected)
	{
	    attributes_elements(attributes_info);
	    attributes_info->elements_selected = FALSE;
	}
	/*
	 * user selected 'live' flag selection 'depth'
	 */
	else if (attributes_info->depth_selected)
	{
	    attributes_depth(attributes_info);
	    attributes_info->depth_selected = FALSE;
	}
	/*
	 * user selected 'live' flag selection 'time'
	 */
	else if (attributes_info->time_selected)
	{
	    attributes_time(attributes_info);
	    attributes_info->time_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'control'
	 */
	else if (attributes_info->control_selected)
	{
	    attributes_control(attributes_info);
	    attributes_info->control_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'show_framenum'
	 */
	else if (attributes_info->show_framenum_selected)
	{
	    attributes_show_framenum(attributes_info);
	    attributes_info->show_framenum_selected = FALSE;
	}
	/*
	 * user selected 'live' float selection 'speed'
	 */
	else if (attributes_info->speed_selected)
	{
	    attributes_speed(attributes_info);
	    attributes_info->speed_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_display
| 
|       Purpose: GUI Driver for pane 'display'
| 
|         Input: form - pointer to the form tree
|                display_info - pointer to options_display struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_display(
     options_display *display_info)

{

	/*
	 * user selected 'live' cycle selection 'norm_type'
	 */
	if (display_info->norm_type_selected)
	{
	    display_norm_type(display_info);
	    display_info->norm_type_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'norm_method'
	 */
	else if (display_info->norm_method_selected)
	{
	    display_norm_method(display_info);
	    display_info->norm_method_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'red_mapcol'
	 */
	else if (display_info->red_mapcol)
	{
	    display_red_mapcol(display_info);
	    display_info->red_mapcol = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'green_mapcol'
	 */
	else if (display_info->green_mapcol)
	{
	    display_green_mapcol(display_info);
	    display_info->green_mapcol = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'blue_mapcol'
	 */
	else if (display_info->blue_mapcol)
	{
	    display_blue_mapcol(display_info);
	    display_info->blue_mapcol = FALSE;
	}
	/*
	 * user selected 'live' string selection 'red_function'
	 */
	else if (display_info->red_function_selected)
	{
	    display_red_function(display_info);
	    display_info->red_function_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'green_function'
	 */
	else if (display_info->green_function_selected)
	{
	    display_green_function(display_info);
	    display_info->green_function_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'blue_function'
	 */
	else if (display_info->blue_function_selected)
	{
	    display_blue_function(display_info);
	    display_info->blue_function_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_lists
| 
|       Purpose: GUI Driver for pane 'lists'
| 
|         Input: form - pointer to the form tree
|                lists_info - pointer to options_lists struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_lists(
     options_lists *lists_info)

{

	/*
	 * user selected 'live' list selection 'animate_list'
	 */
	if (lists_info->animate_list_selected)
	{
	    lists_animate_list(lists_info);
	    lists_info->animate_list_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'band_list'
	 */
	else if (lists_info->band_list_selected)
	{
	    lists_band_list(lists_info);
	    lists_info->band_list_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_function
| 
|       Purpose: GUI Driver for pane 'function'
| 
|         Input: form - pointer to the form tree
|                function_info - pointer to options_function struct
| 
|        Output: None
|    Written By: conductor -program_name animate -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_function(
     options_function *function_info)

{

	/*
	 * user clicked on pane action button selection 'create'
	 */
	if (function_info->create)
	{
	    function_create(function_info);
	    function_info->create = FALSE;
	}


}


