 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcolorspace
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcolorspace.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Short description of program
|
|       Purpose: main program for kcolorspace
|
|         Input:
|		char *clui_info->i_file; {First Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->type_toggle; {Type of colorspace to be applied to the input image}
|		int clui_info->type_flag; {TRUE if -type specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject src, dest;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(kcolorspace_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "ENVISION", "kcolorspace",
		kcolorspace_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcolorspace_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if (!(src = kpds_open_input_object(clui_info->i_file))) 
        {
           kerror(NULL, "kcolorspace",
                  "Failed to open input object '%s'.", clui_info->i_file);
           kexit(KEXIT_FAILURE);
        }
 
        if (!(dest = kpds_open_output_object(clui_info->o_file)))
	{
           kpds_close_object(src);
           kerror(NULL, "kcolorspace",
                  "Failed to open output object '%s'.", clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!kcolor_set_attribute(src, KCOLOR_COLORSPACE,
			clui_info->type_toggle))
	{
           kerror(NULL, "kcolorspace", "kcolor_set_attribute failed to \
colorspace on input image '%s'.", clui_info->i_file);
           kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
        /*
         * The colorspace should have no side effects on the destination
         * object.  It will only manipulate the map data.
         *
         * Since the source object may contain additional attributes
         * that may or may not be part of the image data model,
         * the source object needs to be copied to the destination object
         * so that the user is not surprised by unwanted side effects.
         * Example: removal of value or location data.
         */
        if (!kpds_copy_object(src, dest))
        {
           kerror(NULL, "kcolorspace", "kpds_copy_object failed to copy '%s' \
to '%s'.", clui_info->i_file, clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }
	kpds_close_object(src);
	kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcolorspace_usage_additions
| 
|       Purpose: Prints usage additions in kcolorspace_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcolorspace
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcolorspace_usage_additions(void)
{
	kfprintf(kstderr, "\tShort description of program\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcolorspace_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcolorspace_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcolorspace
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcolorspace_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
