#include <xvinclude.h>

/*
 *  This program displays an image object containing the mandril; underneath
 *  the image object are four zoom objects, each zoom object using a zoom factor
 *  that is larger than the last.  Without installing any event handlers, the
 *  zoom objects will automatically update as the user clicks within the image
 *  object, since each zoom object uses the same data object as the image 
 *  object.  
 *  
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	kobject  data_object;
	char     *filename = "image:mandril";
	xvobject image, zoom, position, parent, last = NULL;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* allow different images to be used, as in "% example image:lizard" */
	if (argc > 1)
	   filename = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* open the data object associated with the input image */
	data_object = kpds_open_object(filename, KOBJ_READ);


	/*
         * a manager will be the backplane for the image and zoom objects
         */
	parent = xvw_create_manager(NULL, "parent");

	/*
         *  create the image object; associate it with the data object
         *  representing the input file, and center it in the middle of parent
         */
	image = xvw_create_image(parent, "image");
	xvw_set_attributes(image,
		           XVW_IMAGE_IMAGEOBJ, data_object,
		           XVW_LEFT_OF,        NULL,
		           XVW_RIGHT_OF,       NULL,
		           NULL);

	/*
	 *  create four zoom objects from left to right, each zoom object
         *  using the same data object as the image, and each zoom object
         *  using a larger zoom factor than the last.  Use the attribute
         *  XVW_ZOOM_UPDATEMODE to specify update on button click rather than
         *  on continuous pointer motion.
	 */
	for (i = 0; i < 4; i++)
	{
	   zoom  = xvw_create_zoom(parent, "zoom");
	   xvw_set_attributes(zoom,
		              XVW_IMAGE_IMAGEOBJ,  data_object,
		              XVW_ZOOM_UPDATEMODE, KZOOM_UM_BUTTON_PRESS,
		              XVW_ZOOM_FACTOR,     (float) (i+1)*4,
		              XVW_MAXIMUM_WIDTH,   150,
		              XVW_MAXIMUM_HEIGHT,  150,
		              XVW_BELOW,           image,
		              XVW_RIGHT_OF,        last,
		              NULL);
	   last = zoom;
	}

	/* display & run */
	xvf_run_form();
}
