#include <xvinclude.h>

void  quit_program       PROTO((xvobject, kaddr, XEvent *));
void  region_of_interest PROTO((xvobject, kaddr, kaddr));

xvobject img_visual_obj; /* image object to display entire image */
xvobject zoom_visual_obj; /* zoom object                          */

/*
 * This program puts up an image object displaying the entire image; it
 * also creates a zoom object that is updated on button press in the image.
 *
 * First, click in the image to position the zoomed portion of the image
 * in the zoom window.  Then, draw a polyline in the zoom window outlining
 * the irregular region of interest, which will be displayed in the small
 * image window to the lower right.
 *
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;        /* backplane for both image objects      */
        xvobject roi_visual_obj; /* image object to display extracted ROI */
	kobject  data_obj;       /* data object visualized as image       */
	char     *filename = "image:mandril";

	/* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }
	
        /* use filename from cmd line if provided */
        if (argc > 1)
           filename = argv[1];

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "parent");

	/* create the image object which will display the entire image */
        img_visual_obj = xvw_create_image(manager, "image");

	/* associate the image data with the image visual object */
	data_obj = kpds_open_input_object(filename);
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, data_obj);

	/* create the image object which will display the region of interest */
        roi_visual_obj = xvw_create_image(manager, "roi");
        xvw_set_attributes(roi_visual_obj,
		           XVW_BELOW,    img_visual_obj,
		           XVW_LEFT_OF,  NULL,
		           NULL);

	/* add the action handler to quit the program */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program, NULL, TRUE);

	zoom_visual_obj = xvw_create_zoom(manager, "zoom");
        xvw_set_attributes(zoom_visual_obj,
                           XVW_BELOW,           img_visual_obj,
                           XVW_RIGHT_OF,        NULL,
			   XVW_MAXIMUM_WIDTH,   200,
                   	   XVW_MAXIMUM_HEIGHT,  200,
                           XVW_IMAGE_IMAGEOBJ,  data_obj,
                           XVW_ZOOM_FACTOR,     4.0,
                           XVW_ZOOM_UPDATEMODE, KZOOM_UM_BUTTON_PRESS,
			   XVW_IMAGE_IMAGEOBJ, data_obj,
                           NULL);

	/* add the event handler to zoom window to extract ROI */
	xvw_add_event(zoom_visual_obj, ButtonPressMask, region_of_interest,
		      (kaddr) roi_visual_obj);

	/* display and run */
        xvf_run_form();
}

/*
 *  event handler to get region of interest and display the
 *  region of interest in the smaller image visual object.
 */
void  region_of_interest(
    xvobject object, 
    kaddr    client_data,  
    kaddr    call_data)
{
	kobject  iobject = NULL;
 	xvobject roi_visual_obj = (xvobject) client_data;

	xvw_set_attribute(object, XVW_IMAGE_ROI_SHAPE, 
			  KIMAGE_ROI_POLYLINE);
	/* 
	 * simply getting the XVW_IMAGE_ROI attribute causes all
	 * the work to be done automatically;  the user is prompted to
         * rubberband the area of interest, the rubberbanding is performed,
	 * and a data object containing the extracted region of interest
	 * is returned.
	 */
        xvw_get_attribute(object, XVW_IMAGE_ROI, &iobject);
	if (iobject == NULL) return;

	/*
	 * region of interest successfully extracted; update image object
	 */
	xvw_set_attribute(roi_visual_obj, XVW_IMAGE_IMAGEOBJ, iobject);
	kpds_close_object(iobject);
}


/*
 *  action handler to quit program on Key Press 'q'
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

