#include <xvinclude.h>

/* 
 * This program creates a blue 3D mesh plot from info stored in an 
 * array of data points.
 */

#define PLOTSIZE 9
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject plot3d;
	kobject  data_object;
	Coord *plot_points;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	plot_points = (Coord *) malloc(PLOTSIZE * sizeof(Coord));

	plot_points[0].x = 0.0;
	plot_points[0].y = 0.0;
	plot_points[0].z = 0.0;

	plot_points[1].x = 1.0;
	plot_points[1].y = 0.0;
	plot_points[1].z = 0.25;

	plot_points[2].x = 2.0;
	plot_points[2].y = 0.0;
	plot_points[2].z = 0.5;

	plot_points[3].x = 0.0;
	plot_points[3].y = 1.0;
	plot_points[3].z = 0.25;

	plot_points[4].x = 1.0;
	plot_points[4].y = 1.0;
	plot_points[4].z = 0.5;

	plot_points[5].x = 2.0;
	plot_points[5].y = 1.0;
	plot_points[5].z = 0.75;

	plot_points[6].x = 0.0;
	plot_points[6].y = 2.0;
	plot_points[6].z = 0.5;

	plot_points[7].x = 1.0;
	plot_points[7].y = 2.0;
	plot_points[7].z = 0.75;

	plot_points[8].x = 2.0;
	plot_points[8].y = 2.0;
	plot_points[8].z = 1.0;

	/* create a 3D color mesh plot from the VIFF file */
	plot3d = xvw_create_plot3d(NULL, "Plot3D");
	xvw_set_attributes(plot3d, 
                           XVW_PLOT3D_POINTS,           plot_points,
                           XVW_PLOT3D_PLOTSIZE,         PLOTSIZE,
                           XVW_PLOT3D_PLOTTYPE,         KPLOT3D_MESH,
                           XVW_BACKGROUND_COLOR,        "blue",
                           XVW_PLOT3D_PLOTWIDTH,        3,
			   XVW_GRAPHICS_VIEWPORT_MIN_X, 0.15,
			   XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.15,
			   XVW_GRAPHICS_VIEWPORT_MIN_Z, 0.15,
			   XVW_GRAPHICS_VIEWPORT_MAX_X, 0.85,
			   XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.85,
			   XVW_GRAPHICS_VIEWPORT_MAX_Z, 0.85,
			   NULL);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
