#include <xvinclude.h>

/* 
 * This example creates an image with a 3D plot displayed over it.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject image, plot3d;
	char *filename = "image:moon";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the image object & set the file that contains image */
	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* create the 3D plot object & set the file that contains plot */
	plot3d = xvw_create_plot3d(image, "Plot3D");
	xvw_set_attribute(plot3d, XVW_PLOT3D_PLOTFILE, "image:flow");

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
