#include <xvinclude.h>

void  quit_program PROTO((xvobject, kaddr, XEvent *));
void  invert_img   PROTO((xvobject, kaddr, XEvent *, Boolean *));


#define REGION_WIDTH 64

/*
 * This program puts up an image, and installs an event handler which will 
 * invert the image region by region when the button is pressed.  
 * An action handler allows the user to quit the program by pressing 'q'.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject img_visual_obj; /* the image visual object */
	kobject  img_data_obj;   /* the image data object */
	char *filename = "image:ball";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }
	if (argc > 1)
	    filename = argv[1];

	/* create the visual object (default parent, default toplevel) */
        img_visual_obj = xvw_create_image(NULL, "image");

	/* create the data object, using the ball */
	img_data_obj = kpds_open_input_object(filename);

	/* set the region size that we'll be using */
	kpds_set_attribute(img_data_obj, KPDS_VALUE_REGION_SIZE,
			   REGION_WIDTH, REGION_WIDTH, 1, 1, 1);

	/* we'll be putting data of type unsigned byte */
	kpds_set_attribute(img_data_obj, KPDS_VALUE_DATA_TYPE, KUBYTE);

	/* pad w/ 0's in case the image does not have even multiples of 64 */
        kpds_set_attribute(img_data_obj, KPDS_VALUE_INTERPOLATE, KPAD);
        kpds_set_attribute(img_data_obj, KPDS_VALUE_PAD_VALUE, 0.0, 0.0);

	/* associate the image data with the image visual object */
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, img_data_obj);

	/* add the action handler to quit the program */
	xvw_add_action(img_visual_obj, "<Key>q",
	               quit_program, (kaddr) img_data_obj, TRUE);

	/* add the event handler to invert the image */
	xvw_add_event(img_visual_obj, ButtonPressMask,
	              invert_img, (kaddr) img_data_obj);

	/* display and run */
        xvf_run_form();
}

/*
 *  action handler to quit program on Key Press 'q'
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        kobject img_data_obj = (kobject) client_data;

        xvw_destroy(object);
        kpds_close_object(img_data_obj);
        kexit(KEXIT_SUCCESS);
}

/*
 *  event handler to invert image region by region  (square regions)
 */
void  invert_img(
    xvobject object, 
    kaddr    clientData,  
    XEvent   *event,
    Boolean  *dispatch)
{
	kobject img_data_obj;
 	int  i, x;
	unsigned char *data = NULL;
	int num_regions;
 	img_data_obj = (kobject) clientData;

	/* about to start getting & setting data - reset to origin */
        kpds_set_attribute(img_data_obj, KPDS_VALUE_POSITION, 0, 0, 0, 0, 0);

	/* determine the number of regions contained in the image */
        kpds_get_attribute(img_data_obj, KPDS_VALUE_REGION_INFO, 
			   NULL, NULL, NULL, NULL, NULL, &num_regions); 

        for (x = 0; x < num_regions; x++ )
        {
	   /* get the image data for the region */
	   data = kpds_get_data(img_data_obj, KPDS_VALUE_REGION, data);

	   /* invert the value */
	   for (i = 0; i < REGION_WIDTH*REGION_WIDTH; i++) 
      	      data[i] = ~data[i];

	   /* put the region back w/ inverted value */
	   kpds_put_data(img_data_obj, KPDS_VALUE_REGION, data);
        }
}
