/*
 *  This example displays the threshold object, and
 *  allows you to do pixel windowing and pixel thresholding
 *  on the mandril image.
 */
#include <xvinclude.h>

void  quit_program PROTO((xvobject, kaddr, XEvent *));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent, image, threshold;
	kobject data_object;
	char *filename = "image:mandril";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* support filename specified on command line */
	if (argc > 1)
           filename = argv[1];

        /* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* open data object to be displayed in image & threshold objects */
	data_object = kpds_open_input_object(filename);

	/* create manager to be the parent object */
	parent = xvw_create_manager(NULL, "parent");

	/* create image object */
	image = xvw_create_image(parent, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEOBJ, data_object);

        /* create threshold object */
        threshold = xvw_create_threshold(parent, "threshold");
        xvw_set_attributes(threshold,
		           XVW_BELOW,          image,
			   XVW_WIDTH,          500,
			   XVW_HEIGHT,         150,
			   XVW_COLOR_COLOROBJ, data_object,
                           NULL);

	/* display menuform for threshold object */
	xvw_activate_menu(threshold);

        /* add the action handler to quit on KeyPress 'q' */
        xvw_add_event(image, ButtonPressMask, quit_program, parent);

	/* display and run */
        xvf_run_form();
}

/*
 *  action handler to quit program on "q"
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvobject parent = (xvobject) client_data;

        xvw_destroy(xvw_toplevel(parent));
}

