#include <xvinclude.h>

/*
 * This example is for testing the read only color allocation policy.
 * Otherwise, it is identical to example # 6.
 */

void  image_handler   PROTO((xvobject, kaddr, XEvent *, Boolean *));

void main(
    int  argc,
    char **argv,
    char **envp)
{
        xvobject image, pseudo, colorcell;
	char *filename = "image:kitten";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	if (argc > 1)
	    filename = argv[1];

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create an image object to display the file */
	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* create a pseudocolor object */
        pseudo = xvw_create_pseudo(NULL, "pseudo");
        xvw_set_attributes(pseudo,
			   XVW_COLOR_COLORFILE,     filename,
		           XVW_PSEUDO_UPDATE_ONADD, TRUE,
			   XVW_PSEUDO_ADD,          10,
			   NULL);


	colorcell = xvw_create_colorcell(image, "colorcell");
	xvw_set_attributes(colorcell,
			   XVW_COLOR_COLORFILE,  filename,
		           XVW_COLORCELL_INDEX,  10,
		           NULL);

	xvw_add_event(image, ButtonPressMask, image_handler, pseudo);

	/* display & run */
        xvf_run_form();
}

/*
 *  event handler to
 */
void  image_handler(
    xvobject image,
    kaddr    clientData,
    XEvent   *event,
    Boolean  *dispatch)
{
	double indx;
	xvobject pseudo = (xvobject) clientData;


	xvw_get_attribute(image, XVW_IMAGE_VALUE, &indx);
	xvw_set_attribute(pseudo, XVW_PSEUDO_ADD, (int) indx);
}
