#include <xvinclude.h>

/*
 *  This program displays a pseudocolor object working off the information
 *  found in the "image:mandril" file, and an image object also displaying the
 *  mandril image.  An event handler is installed on the image object so that
 *  when you hold the mouse button down and move the pointer across the image,
 *  the Red, Green, and Blue scrollbars of the pseudocolor object will move
 *  to reflect the color of the pixels under the mouse pointer.
 */

void  image_handler   PROTO((xvobject, kaddr, XEvent *, Boolean *));

void main(
   int  argc,
   char **argv,
   char **envp)
{
        xvobject image, pseudo;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create pseudocolor object, associated w/ mandril image */ 
        pseudo = xvw_create_pseudo(NULL, "pseudo");
        xvw_set_attributes(pseudo, 
			   XVW_COLOR_COLORFILE, "image:mandril",
                	   XVW_WIDTH,  300,
                	   XVW_HEIGHT, 150,
			   NULL);

	/* create image object, also associated w/ mandril image */ 
	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, "image:mandril");

	/* add event handler on image object on button press or button motion */
	xvw_add_event(image, ButtonPressMask|ButtonMotionMask, 
                      image_handler, pseudo);

	/* display and run */
        xvf_run_form();
}

void  image_handler(
    xvobject image,
    kaddr    clientData,
    XEvent   *event,
    Boolean  *dispatch)
{
	double indx;
	xvobject pseudo = (xvobject) clientData;

	/* get the pixel value at the location of the pointer */
	xvw_get_attribute(image, XVW_IMAGE_VALUE, &indx);

	/* 
	 * use the XVW_PSEUDO_ADD attribute to cause the pseudocolor object's
         * scrollbars to indicate the color of the pixel that the pointer 
         * is positioned over.  have to use XVW_PSEUDO_CLEAR to clear the
         * previous pixel from the pseudocolor list; if we didn't, the current
         * pixel would be changed to be of the same color as the previous pixel.
         * (all pixels in the pseudocolor list are displayed in the same color;
         *  by keeping the list at size 1, we ensure that setting attribute
         *  XVW_PSEUDO_ADD simply causes the scrollbars to reflect the color 
         *  of the current pixel).
	 */
	xvw_set_attributes(pseudo,
		           XVW_PSEUDO_CLEAR, TRUE,  
		           XVW_PSEUDO_ADD,   (int) indx,
			   NULL);
}
