#include <xvinclude.h>

void  update_colorcell   PROTO((xvobject, kaddr, XEvent *, Boolean *));

/* 
 *  This program creates an image object which displays the kitten image.
 *  Then, a colorcell object is created. A colorcell object is associated with
 *  a pixel value in an image; it is a box filled with the color in which
 *  the pixel appears, and labelled with the pixel value.
 *  
 *  An event handler is installed which allows you to click the mouse in
 *  the image;  the colorcell object will be updated with the color and
 *  value of the pixel on which the mouse was clicked.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])

{
	xvobject manager, image, colorcell, label;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* Create a manager to parent the image and colorcell objects  */
	manager = xvw_create_manager(NULL, "manager");

	/* create a 35x35 colorcell object in the  upper right hand corner */
	colorcell = xvw_create_colorcell(manager, "colorcell");
	xvw_set_attributes(colorcell,
		XVW_COLOR_COLORFILE, "image:kitten",
		XVW_BELOW,	     NULL,
		XVW_WIDTH,	     35,
		XVW_HEIGHT,	     35,
		XVW_LEFT_OF,	     NULL,
		NULL);

	/* put a label, just to be fancy */
	label = xvw_create_label(manager, "label");
	xvw_set_attributes(label,
			   XVW_LEFT_OF, colorcell,
			   XVW_ABOVE,   colorcell,
			   XVW_BELOW,   colorcell,
			   XVW_LABEL,   "This is the colorcell object =>",
		           NULL);

	/* create the image object below the colorcell; specify the image */
	image = xvw_create_image(manager, "image");
	xvw_set_attributes(image,
		XVW_IMAGE_IMAGEFILE, "image:kitten",
		XVW_BELOW,	     colorcell,
		NULL);

	/* add the event handler to update the colorcell */
	xvw_add_event(image, ButtonPressMask | ButtonMotionMask,
                      update_colorcell, (kaddr)colorcell);

	/* display & run */
	xvf_run_form();
}


/*
 *  event handler to update the colorcell index 
 */
void  update_colorcell(
    xvobject object, 
    kaddr    clientData,  
    XEvent   *event,
    Boolean  *dispatch)
{
	double   value;
	xvobject colorcell = (xvobject) clientData;

	/* get the value of the pixel where the mouse was clicked */
	xvw_get_attribute(object, XVW_IMAGE_VALUE, &value);

	/* update the colorcell to reflect that pixel value */ 
	xvw_set_attribute(colorcell, XVW_COLORCELL_INDEX, (int) value);
}
