#include <xvinclude.h>

int  autocolor_index = KNONE;

void list1_cb PROTO((xvobject, kaddr, kaddr));
void list2_cb PROTO((xvobject, kaddr, kaddr));
void timer_cb PROTO((xvobject, kaddr, int *));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  data_object;
	xvobject image, manager, label; 
	xvobject list1, list2, actual_list;
	char     *filename = "image:moon";
	char     **operation_list, **autocolor_list;
	int      autocolor_num, operation_num;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	if (argc > 1)
	   filename = argv[1];

	data_object = kpds_open_input_object(filename);

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	image = xvw_create_image(NULL, "image");
	xvw_set_attributes(image,
		XVW_IMAGE_IMAGEOBJ,	data_object,
		XVW_COLOR_ALLOC_POLICY, KCOLOR_ALLOC_READWRITE,
		NULL);

	manager = xvw_create_manager(NULL, "Autocolor List");
        xvw_set_attribute(manager, XVW_RESIZABLE, TRUE);
	label = xvw_create_label(manager, "label1");
	xvw_set_attribute(label, XVW_LABEL, "pick one of these:");
	list1 = xvw_create_list(manager, "Static Autocolor List");
	xvw_set_attributes(list1,
		           XVW_RESIZABLE,     TRUE,
		           XVW_CHAR_HEIGHT,   10.0,
		           XVW_CHAR_WIDTH,    22.0,
		           XVW_BELOW,         label,
		           NULL);
	actual_list = xvw_retrieve_list(list1);

	kcolor_get_attribute(data_object, KCOLOR_MAP_AUTOCOLOR_LIST,
                             &autocolor_list, &autocolor_num);
	xvw_change_list(actual_list, autocolor_list, 
			autocolor_num, FALSE);
	xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT, 
			 list1_cb, data_object);

	label = xvw_create_label(manager, "label");
	xvw_set_attributes(label, 
			   XVW_LABEL, "then, one of these:",
			   XVW_RIGHT_OF, list1,	
		           NULL);
	list2 = xvw_create_list(manager, "Dynamic Autocolor List");
	xvw_set_attributes(list2,
		           XVW_RESIZABLE,     TRUE,
		           XVW_CHAR_HEIGHT,   10.0,
		           XVW_CHAR_WIDTH,    22.0,
		           XVW_RIGHT_OF,      list1,
		           XVW_BELOW,         label,
		           NULL);
	actual_list = xvw_retrieve_list(list2);
	kcolor_get_attribute(data_object, KCOLOR_MAP_OPERATION_LIST,
                             &operation_list, &operation_num);
	xvw_change_list(actual_list, operation_list, 
			operation_num, FALSE);
	xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT, list2_cb, NULL);
	xvw_add_timeout(image, 0.1, timer_cb, data_object);

	xvf_run_form();
}

void list1_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	int indx;
	xvw_list_struct *list = (xvw_list_struct *) call_data;
 	kobject data_object = (kobject) client_data;
	
	kfprintf(kstderr,"Setting Automatic Colormap '%s' \n", list->string);
	kcolor_set_attribute(data_object, KCOLOR_MAP_AUTOCOLOR, 
			     list->list_index);
}

void list2_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        xvw_list_struct *list = (xvw_list_struct *) call_data;
        char *type = (char *) client_data;

        kfprintf(kstderr,"Applying Autocolor Operation '%s' \n", list->string);

        /* #defines for autocolor operations start at 100 */
        autocolor_index = list->list_index+100; 
}


void timer_cb(
    xvobject object,
    kaddr    client_data,
    int	     *stop_timer)
{
        kobject data = (kobject) client_data;

	if (autocolor_index != KNONE)
	    kcolor_set_attribute(data, KCOLOR_MAP_OPERATION, autocolor_index);
}
