#include <xvinclude.h>

/*
 *
 * This program creates a textstring annotation.
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the textstring can be
 * interactively moved by "grabbing" it in the middle with the left mouse
 * button. The internal menuform for the textstring may be displayed by 
 * clicking the middle mouse button on the textstring annoation while the 
 * parent is in edit mode.
 */

void main( 
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject textstring;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so
         *  the user can put it in edit mode & move the textstring around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,      300,
                           XVW_HEIGHT,     300,
                           XVW_SELECTABLE, TRUE,
                           NULL);

        /*
         *  create the textstring object.  specify placement in world 
         *  coordinates, set the string to be displayed, and the justification.
         *  make it menuable so user has access to its internal menuform.
         */
        textstring = xvw_create_textstring(parent, "textstring");
        xvw_set_attributes(textstring,
		XVW_STRING_XPLACEMENT,	  0.5,
		XVW_STRING_YPLACEMENT,	  0.5,
		XVW_STRING_STRING,        "Test text string",
		XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
                XVW_MENUABLE,             TRUE,
                NULL);

        /*
         *  activate the internal menuform so user doesn't
         *  have to bring it up.
         */
        xvw_activate_menu(textstring);

        /* display & run the program */
        xvf_run_form();
}
