#include <xvinclude.h>

/*
 *
 * This example creates a window with a single circle annotation in it.
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the circle can be
 * interactively moved by "grabbing" it in the middle with the left mouse
 * button; grabbing it near an end will cause the circle to resize.
 *
 * In this example, the internal menuform for the circle is displayed 
 * automatically.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject circle;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so
         *  the user can put it in edit mode & move the circle around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,      300,
                           XVW_HEIGHT,     300,
                           XVW_SELECTABLE, TRUE,
                           NULL);

	/*
	 *  create the circle object.  specify dimensions in world coordinates,
         *  make it menuable so user has access to its internal menuform.
	 */
        circle = xvw_create_circle(parent, "circle");
        xvw_set_attributes(circle,
                           XVW_CIRCLE_XCENTER, 0.5,
                           XVW_CIRCLE_YCENTER, 0.5,
                           XVW_CIRCLE_RADIUS,  0.1,
                           XVW_MENUABLE, TRUE,
                           NULL);

	/*
	 *  activate the internal menuform so user doesn't
         *  have to bring it up.
	 */
	xvw_activate_menu(circle);

	/* display & run the program */
        xvf_run_form();
}
