#include <xvinclude.h>

/*
 * This program demonstrates the use of the annotation menu.
 */

void main(int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
        xvobject menu;
        xvobject parent;
        xvobject canvas;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* a manager object will be the backplane for the annotation menu */
	parent = xvw_create_manager(NULL, "parent");
	

	/* create the annotations menu */
        menu = xvw_create_annotatemenu(parent, "AnnotationMenu");
        xvw_set_attributes(menu,
                XVW_BORDER_WIDTH,           0,
                XVW_BELOW,                  NULL,
                XVW_RIGHT_OF,               NULL,
                XVW_MINIMUM_HEIGHT,         100,
                NULL);

	/* create a canvas on which the user can create annotations */
	canvas = xvw_create_canvas(parent, "canvas");
	xvw_set_attributes(canvas,
			   XVW_BELOW,      NULL,
                           XVW_RIGHT_OF,   menu,
			   XVW_WIDTH,      512,
                           XVW_HEIGHT,     512,
                           NULL);

	/*
	 *  tell annotations menu that newly created annotations
	 *  should be placed in the canvas.
	 */
	xvw_set_attribute(menu, XVW_ANNOTATEMENU_WORKSPACE, canvas);

	/* display & run the program */
        xvf_run_form();
}

